/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.math.functions.gsl.integration;

import internal.toolkit.base.core.math.functions.gsl.Utility;
import internal.toolkit.base.core.math.functions.gsl.integration.IntegrationResult;
import java.util.function.DoubleUnaryOperator;

class QK {
    private double[] fv1;
    private double[] fv2;
    private double result;
    private double abserr;
    private double resabs;
    private double resasc;

    static QK of(DoubleUnaryOperator fn, double a, double b, double[] xgk, double[] wg, double[] wgk) {
        double fval2;
        double fval1;
        double abscissa;
        int j;
        int n = xgk.length;
        QK qk = new QK(n);
        double center = 0.5 * (a + b);
        double half_length = 0.5 * (b - a);
        double abs_half_length = Math.abs(half_length);
        double f_center = fn.applyAsDouble(center);
        double result_gauss = 0.0;
        double result_kronrod = f_center * wgk[n - 1];
        double result_abs = Math.abs(result_kronrod);
        if (n % 2 == 0) {
            result_gauss = f_center * wg[n / 2 - 1];
        }
        for (j = 0; j < (n - 1) / 2; ++j) {
            int jtw = j * 2 + 1;
            abscissa = half_length * xgk[jtw];
            fval1 = fn.applyAsDouble(center - abscissa);
            fval2 = fn.applyAsDouble(center + abscissa);
            double fsum = fval1 + fval2;
            qk.fv1[jtw] = fval1;
            qk.fv2[jtw] = fval2;
            result_gauss += wg[j] * fsum;
            result_kronrod += wgk[jtw] * fsum;
            result_abs += wgk[jtw] * (Math.abs(fval1) + Math.abs(fval2));
        }
        for (j = 0; j < n / 2; ++j) {
            int jtwm1 = j * 2;
            abscissa = half_length * xgk[jtwm1];
            fval1 = fn.applyAsDouble(center - abscissa);
            fval2 = fn.applyAsDouble(center + abscissa);
            qk.fv1[jtwm1] = fval1;
            qk.fv2[jtwm1] = fval2;
            result_kronrod += wgk[jtwm1] * (fval1 + fval2);
            result_abs += wgk[jtwm1] * (Math.abs(fval1) + Math.abs(fval2));
        }
        double mean = result_kronrod * 0.5;
        double result_asc = wgk[n - 1] * Math.abs(f_center - mean);
        for (j = 0; j < n - 1; ++j) {
            result_asc += wgk[j] * (Math.abs(qk.fv1[j] - mean) + Math.abs(qk.fv2[j] - mean));
        }
        double err = (result_kronrod - result_gauss) * half_length;
        qk.result = result_kronrod *= half_length;
        qk.resabs = result_abs *= abs_half_length;
        qk.resasc = result_asc *= abs_half_length;
        qk.abserr = Utility.rescale_error(err, result_abs, result_asc);
        return qk;
    }

    private QK(int n) {
        this.fv1 = new double[n];
        this.fv2 = new double[n];
    }

    public double[] getFv1() {
        return this.fv1;
    }

    public double[] getFv2() {
        return this.fv2;
    }

    public double getResult() {
        return this.result;
    }

    public double getAbserr() {
        return this.abserr;
    }

    public double getResabs() {
        return this.resabs;
    }

    public double getResasc() {
        return this.resasc;
    }

    public void setResasc(double resasc) {
        this.resasc = resasc;
    }

    IntegrationResult result() {
        return new IntegrationResult(this.result, this.abserr, this.resabs, this.resasc);
    }
}

