/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.dstats;

import jdplus.toolkit.base.api.dstats.BoundaryType;
import jdplus.toolkit.base.api.dstats.ContinuousDistribution;
import jdplus.toolkit.base.api.dstats.DStatException;
import jdplus.toolkit.base.api.stats.ProbabilityType;
import lombok.Generated;
import nbbrd.design.Internal;

@Internal
public final class ProbInvFinder {
    private static final int MAXITER = 100;

    public static double find(double p, double a, double ptol, double xtol, ContinuousDistribution cdist) {
        double x = a;
        double fx = cdist.getProbability(x, ProbabilityType.Lower) - p;
        double xprev = x;
        int niter = 0;
        while (++niter < 100 && (Math.abs(fx) > ptol || Math.abs(xprev - x) > xtol)) {
            xprev = x;
            double dfx = 0.0;
            try {
                dfx = cdist.getDensity(xprev);
            }
            catch (DStatException dStatException) {
                // empty catch block
            }
            if (dfx == 0.0) {
                dfx = Math.sqrt(ptol);
            }
            x = xprev - fx / dfx;
            BoundaryType lbound = cdist.hasLeftBound();
            BoundaryType rbound = cdist.hasRightBound();
            switch (lbound) {
                case Asymptotical: {
                    double lb = cdist.getLeftBound();
                    if (!(x <= lb)) break;
                    x = (xprev + lb) / 2.0;
                    break;
                }
                case Finite: {
                    double lb = cdist.getLeftBound();
                    if (!(x < lb)) break;
                    x = lb;
                    break;
                }
            }
            switch (rbound) {
                case Asymptotical: {
                    double rb = cdist.getRightBound();
                    if (!(x >= rb)) break;
                    x = (xprev + rb) / 2.0;
                    break;
                }
                case Finite: {
                    double rb = cdist.getRightBound();
                    if (!(x > rb)) break;
                    x = rb;
                    break;
                }
            }
            fx = cdist.getProbability(x, ProbabilityType.Lower) - p;
        }
        return ProbInvFinder.finish(p, x, xtol, cdist);
    }

    private static double finish(double p, double x, double xtol, ContinuousDistribution cdist) {
        double m;
        double step = xtol;
        double a = x;
        double K = 4.0;
        while (true) {
            double pcur;
            if ((pcur = cdist.getProbability(a, ProbabilityType.Lower)) == p) {
                return a;
            }
            if (pcur < p) break;
            a = ProbInvFinder.remove(a, step, xtol, cdist);
            step *= K;
        }
        step = xtol;
        double b = x;
        while (true) {
            double pcur;
            if ((pcur = cdist.getProbability(b, ProbabilityType.Lower)) == p) {
                return b;
            }
            if (pcur > p) break;
            b = ProbInvFinder.add(b, step, xtol, cdist);
            step *= K;
        }
        do {
            double pcur;
            if ((pcur = cdist.getProbability(m = (b + a) / 2.0, ProbabilityType.Lower)) == p) {
                return m;
            }
            if (pcur < p) {
                a = m;
                continue;
            }
            b = m;
        } while (b - a > xtol);
        return m;
    }

    private static double remove(double x, double d, double xtol, ContinuousDistribution cdist) {
        double nx = x - d;
        BoundaryType lb = cdist.hasLeftBound();
        if (lb == BoundaryType.None) {
            return nx;
        }
        double l = cdist.getLeftBound();
        if (nx > l) {
            return nx;
        }
        if (lb == BoundaryType.Asymptotical) {
            return l + xtol;
        }
        return l;
    }

    private static double add(double x, double d, double xtol, ContinuousDistribution cdist) {
        double nx = x + d;
        BoundaryType rb = cdist.hasRightBound();
        if (rb == BoundaryType.None) {
            return nx;
        }
        double r = cdist.getRightBound();
        if (nx < r) {
            return nx;
        }
        if (rb == BoundaryType.Asymptotical) {
            return r - xtol;
        }
        return r;
    }

    @Generated
    private ProbInvFinder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

