/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.ar;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.core.ar.AutoRegressiveEstimation;

public class LevinsonAlgorithm
implements AutoRegressiveEstimation {
    private static final double SMALL = 1.0E-9;
    private double[] y;
    private double[] a;

    @Override
    public boolean estimate(DoubleSeq y, int m) {
        this.y = new double[y.length()];
        y.copyTo(this.y, 0);
        return this.calc(m);
    }

    @Override
    public DoubleSeq coefficients() {
        return DoubleSeq.of((double[])this.a);
    }

    @Override
    public DoubleSeq data() {
        return Doubles.of((double[])this.y);
    }

    private boolean calc(int m) {
        int n = this.y.length - 1;
        double[] r = new double[m + 1];
        for (int i = 0; i <= m; ++i) {
            for (int j = 0; j <= n - i; ++j) {
                int n2 = i;
                r[n2] = r[n2] + this.y[j] * this.y[j + i];
            }
        }
        double[] ak = new double[m + 1];
        ak[0] = 1.0;
        double ek = r[0];
        for (int k = 0; k < m; ++k) {
            double lambda = 0.0;
            for (int j = 0; j <= k; ++j) {
                lambda -= ak[j] * r[k + 1 - j];
            }
            lambda /= ek;
            for (int l = 0; l <= (k + 1) / 2; ++l) {
                double tmp = ak[k + 1 - l] + lambda * ak[l];
                int n3 = l;
                ak[n3] = ak[n3] + lambda * ak[k + 1 - l];
                ak[k + 1 - l] = tmp;
            }
            ek *= 1.0 - lambda * lambda;
        }
        this.a = new double[m];
        for (int i = 0; i < m; ++i) {
            this.a[i] = -ak[i + 1];
        }
        return true;
    }
}

