/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.core.ar;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.ar.AutoRegressiveEstimation;

public class BurgAlgorithm
implements AutoRegressiveEstimation {
    private double[] y;
    private double[] a;

    @Override
    public boolean estimate(DoubleSeq y, int m) {
        this.y = new double[y.length()];
        y.copyTo(this.y, 0);
        return this.calc(m);
    }

    @Override
    public DoubleSeq coefficients() {
        return DoubleSeq.of((double[])this.a);
    }

    @Override
    public DoubleSeq data() {
        return DoubleSeq.of((double[])this.y);
    }

    private boolean calc(int m) {
        int n = this.y.length - 1;
        double[] ak = new double[m + 1];
        ak[0] = 1.0;
        double[] f = (double[])this.y.clone();
        double[] b = (double[])this.y.clone();
        double dk = 0.0;
        for (int j = 0; j <= n; ++j) {
            dk += 2.0 * f[j] * f[j];
        }
        dk -= f[0] * f[0] + b[n] * b[n];
        for (int k = 0; k < m; ++k) {
            double t2;
            double t1;
            int l;
            double mu = 0.0;
            for (l = 0; l <= n - k - 1; ++l) {
                mu += f[l + k + 1] * b[l];
            }
            mu *= -2.0 / dk;
            for (l = 0; l <= (k + 1) / 2; ++l) {
                t1 = ak[l] + mu * ak[k + 1 - l];
                t2 = ak[k + 1 - l] + mu * ak[l];
                ak[l] = t1;
                ak[k + 1 - l] = t2;
            }
            for (l = 0; l <= n - k - 1; ++l) {
                t1 = f[l + k + 1] + mu * b[l];
                t2 = b[l] + mu * f[l + k + 1];
                f[l + k + 1] = t1;
                b[l] = t2;
            }
            dk = (1.0 - mu * mu) * dk - f[k + 1] * f[k + 1] - b[n - k - 1] * b[n - k - 1];
        }
        this.a = new double[m];
        for (int i = 0; i < m; ++i) {
            this.a[i] = -ak[i + 1];
        }
        return true;
    }
}

