/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.util;

import jdplus.toolkit.base.api.util.SubArrayOfInt;
import jdplus.toolkit.base.api.util.SubTableOfInt;
import jdplus.toolkit.base.api.util.Table;
import nbbrd.design.PrimitiveReplacementOf;

@PrimitiveReplacementOf(generic=Table.class, primitive=int.class)
public class TableOfInt {
    private final int[] m_data;
    private final int m_nrows;
    private final int m_ncols;

    public TableOfInt(int nrows, int ncols) {
        this.m_data = new int[nrows * ncols];
        this.m_nrows = nrows;
        this.m_ncols = ncols;
    }

    public TableOfInt(TableOfInt table) {
        this.m_data = (int[])table.m_data.clone();
        this.m_nrows = table.m_nrows;
        this.m_ncols = table.m_ncols;
    }

    public SubArrayOfInt column(int col) {
        return SubArrayOfInt.create(this.m_data, col * this.m_nrows, (col + 1) * this.m_nrows, 1);
    }

    public SubTableOfInt extract() {
        return new SubTableOfInt(this.m_data, 0, this.m_nrows, this.m_ncols, 1, this.m_nrows);
    }

    public SubTableOfInt extract(int r0, int r1, int c0, int c1) {
        return new SubTableOfInt(this.m_data, r0 + c0 * this.m_nrows, r1 - r0, c1 - c0, 1, this.m_nrows);
    }

    public SubTableOfInt extract(int r0, int c0, int nr, int nc, int rinc, int cinc) {
        return new SubTableOfInt(this.m_data, r0 + c0 * this.m_nrows, nr, nc, rinc, cinc * this.m_nrows);
    }

    public int get(int r, int c) {
        return this.m_data[r + c * this.m_nrows];
    }

    public int getColumnsCount() {
        return this.m_ncols;
    }

    public int getRowsCount() {
        return this.m_nrows;
    }

    public boolean isEmpty() {
        return this.m_data == null;
    }

    public SubArrayOfInt row(int row) {
        return SubArrayOfInt.create(this.m_data, row, row + this.m_ncols * this.m_nrows, this.m_nrows);
    }

    public int[] internalStorage() {
        return this.m_data;
    }

    public void set(int r, int c, int value) {
        this.m_data[r + c * this.m_nrows] = value;
    }
}

