/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.util;

import jdplus.toolkit.base.api.util.SubArrayOfLong;
import jdplus.toolkit.base.api.util.SubTable;
import nbbrd.design.PrimitiveReplacementOf;

@PrimitiveReplacementOf(generic=SubTable.class, primitive=int.class)
public class SubTableOfLong {
    long[] m_data;
    int m_start;
    int m_nrows;
    int m_ncols;
    int m_row_inc;
    int m_col_inc;

    public SubTableOfLong(long[] data, int nrows, int ncols) {
        this.m_data = data;
        this.m_nrows = nrows;
        this.m_ncols = ncols;
        this.m_row_inc = 1;
        this.m_col_inc = nrows;
    }

    public SubTableOfLong(long[] data, int start, int nrows, int ncols, int rowinc, int colinc) {
        this.m_data = data;
        this.m_start = start;
        this.m_nrows = nrows;
        this.m_ncols = ncols;
        this.m_row_inc = rowinc;
        this.m_col_inc = colinc;
    }

    public SubTableOfLong(SubTableOfLong m) {
        this.m_data = m.m_data;
        this.m_start = m.m_start;
        this.m_nrows = m.m_nrows;
        this.m_ncols = m.m_ncols;
        this.m_row_inc = m.m_row_inc;
        this.m_col_inc = m.m_col_inc;
    }

    public SubArrayOfLong column(int c) {
        int beg = this.m_start + c * this.m_col_inc;
        int end = beg + this.m_row_inc * this.m_nrows;
        return SubArrayOfLong.create(this.m_data, beg, end, this.m_row_inc);
    }

    public SubArrayOfLong diagonal() {
        int n = Math.min(this.m_nrows, this.m_ncols);
        int inc = this.m_row_inc + this.m_col_inc;
        return SubArrayOfLong.create(this.m_data, this.m_start, this.m_start + inc * n, inc);
    }

    public SubTableOfLong extract(int r0, int r1, int c0, int c1) {
        return new SubTableOfLong(this.m_data, this.m_start + r0 * this.m_row_inc + c0 * this.m_col_inc, r1 - r0, c1 - c0, this.m_row_inc, this.m_col_inc);
    }

    public SubTableOfLong extract(int r0, int c0, int nrows, int ncols, int rowinc, int colinc) {
        return new SubTableOfLong(this.m_data, this.m_start + r0 * this.m_row_inc + c0 * this.m_col_inc, nrows, ncols, this.m_row_inc * rowinc, this.m_col_inc * colinc);
    }

    public long get(int row, int col) {
        return this.m_data[this.m_start + row * this.m_row_inc + col * this.m_col_inc];
    }

    public int getColumnsCount() {
        return this.m_ncols;
    }

    public int getRowsCount() {
        return this.m_nrows;
    }

    public void move(int dr, int dc) {
        this.m_start += dr * this.m_row_inc + dc * this.m_col_inc;
    }

    public SubArrayOfLong row(int r) {
        int beg = this.m_start + r * this.m_row_inc;
        int end = beg + this.m_col_inc * this.m_ncols;
        return SubArrayOfLong.create(this.m_data, beg, end, this.m_col_inc);
    }

    public void set(long val) {
        if (this.m_row_inc == 1) {
            int c = 0;
            int ic = this.m_start;
            while (c < this.m_ncols) {
                int r = 0;
                int ir = ic;
                while (r < this.m_nrows) {
                    this.m_data[ir] = val;
                    ++r;
                    ++ir;
                }
                ++c;
                ic += this.m_col_inc;
            }
        } else if (this.m_col_inc == 1) {
            int r = 0;
            int ir = this.m_start;
            while (r < this.m_nrows) {
                int c = 0;
                int ic = ir;
                while (c < this.m_ncols) {
                    this.m_data[ic] = val;
                    ++c;
                    ++ic;
                }
                ++r;
                ir += this.m_row_inc;
            }
        } else {
            int c = 0;
            int ic = this.m_start;
            while (c < this.m_ncols) {
                int r = 0;
                int ir = ic;
                while (r < this.m_nrows) {
                    this.m_data[ir] = val;
                    ++r;
                    ir += this.m_row_inc;
                }
                ++c;
                ic += this.m_col_inc;
            }
        }
    }

    public void set(int row, int col, long value) {
        this.m_data[this.m_start + row * this.m_row_inc + col * this.m_col_inc] = value;
    }

    public void shift(int n) {
        block5: {
            block4: {
                if (n >= 0) break block4;
                int del = (this.m_row_inc + this.m_col_inc) * n;
                int c = 0;
                int i = this.m_start;
                while (c < this.m_ncols + n) {
                    int r = 0;
                    int j = i;
                    while (r < this.m_nrows + n) {
                        this.m_data[j] = this.m_data[j - del];
                        ++r;
                        j += this.m_row_inc;
                    }
                    ++c;
                    i += this.m_col_inc;
                }
                break block5;
            }
            if (n <= 0) break block5;
            int del = (this.m_row_inc + this.m_col_inc) * n;
            int c = n;
            int i = this.m_start + (this.m_nrows - 1) * this.m_row_inc + (this.m_ncols - 1) * this.m_col_inc;
            while (c < this.m_ncols) {
                int r = n;
                int j = i;
                while (r < this.m_nrows) {
                    this.m_data[j] = this.m_data[j - del];
                    ++r;
                    j -= this.m_row_inc;
                }
                ++c;
                i -= this.m_col_inc;
            }
        }
    }

    public SubArrayOfLong subDiagonal(int pos) {
        if (pos >= this.m_ncols) {
            return SubArrayOfLong.EMPTY;
        }
        if (-pos >= this.m_nrows) {
            return SubArrayOfLong.EMPTY;
        }
        int beg = this.m_start;
        int inc = this.m_row_inc + this.m_col_inc;
        int n = 0;
        if (pos > 0) {
            beg += pos * this.m_col_inc;
            n = Math.min(this.m_nrows, this.m_ncols - pos);
        } else if (pos < 0) {
            beg -= pos * this.m_row_inc;
            n = Math.min(this.m_nrows + pos, this.m_ncols);
        }
        return SubArrayOfLong.create(this.m_data, beg, beg + inc * n, inc);
    }

    public SubTableOfLong transpose() {
        return new SubTableOfLong(this.m_data, this.m_start, this.m_ncols, this.m_nrows, this.m_col_inc, this.m_row_inc);
    }
}

