/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.util;

import jdplus.toolkit.base.api.util.Arrays2;
import jdplus.toolkit.base.api.util.SubArray;
import nbbrd.design.PrimitiveReplacementOf;

@PrimitiveReplacementOf(generic=SubArray.class, primitive=int.class)
public final class SubArrayOfLong {
    public static final SubArrayOfLong EMPTY = SubArrayOfLong.create(Arrays2.EMPTY_LONG_ARRAY);
    private final long[] m_data;
    private final int m_beg;
    private final int m_end;
    private final int m_inc;

    public static SubArrayOfLong create(long[] data) {
        return new SubArrayOfLong(data, 0, data.length, 1);
    }

    public static SubArrayOfLong create(long[] data, int beg, int end, int inc) {
        return new SubArrayOfLong(data, beg, end, inc);
    }

    private SubArrayOfLong(long[] data, int beg, int end, int inc) {
        this.m_data = data;
        this.m_beg = beg;
        this.m_end = end;
        this.m_inc = inc;
    }

    public void add(int idx, int value) {
        int n = this.m_beg + idx * this.m_inc;
        this.m_data[n] = this.m_data[n] + (long)value;
    }

    public void copy(SubArrayOfLong a) {
        int tcur = this.m_beg;
        int scur = a.m_beg;
        if (this.m_inc == 1 && a.m_inc == 1) {
            while (tcur != this.m_end) {
                this.m_data[tcur++] = a.m_data[scur++];
            }
        } else {
            while (tcur != this.m_end) {
                this.m_data[tcur] = a.m_data[scur];
                tcur += this.m_inc;
                scur += a.m_inc;
            }
        }
    }

    public void copyFrom(long[] a, int start) {
        int scur = start;
        if (this.m_inc == 1) {
            while (tcur != this.m_end) {
                this.m_data[tcur++] = a[scur++];
            }
        } else {
            for (tcur = this.m_beg; tcur != this.m_end; tcur += this.m_inc) {
                this.m_data[tcur] = a[scur++];
            }
        }
    }

    public long get(int idx) {
        return this.m_data[this.m_beg + idx * this.m_inc];
    }

    public int getLength() {
        return this.m_inc == 0 ? 0 : (this.m_end - this.m_beg) / this.m_inc;
    }

    public boolean isEmpty() {
        return this.m_beg == this.m_end;
    }

    public SubArrayOfLong range(int i0, int i1) {
        return new SubArrayOfLong(this.m_data, this.m_beg + i0 * this.m_inc, this.m_beg + i1 * this.m_inc, this.m_inc);
    }

    public void set(long tval) {
        if (this.m_inc == 1) {
            while (cur != this.m_end) {
                this.m_data[cur++] = tval;
            }
        } else {
            for (cur = this.m_beg; cur != this.m_end; cur += this.m_inc) {
                this.m_data[cur] = tval;
            }
        }
    }

    public void set(int idx, long value) {
        this.m_data[this.m_beg + idx * this.m_inc] = value;
    }

    public void add(int del) {
        if (del == 0) {
            return;
        }
        if (this.m_inc == 1) {
            while (cur != this.m_end) {
                int n = cur++;
                this.m_data[n] = this.m_data[n] + (long)del;
            }
        } else {
            for (cur = this.m_beg; cur != this.m_end; cur += this.m_inc) {
                int n = cur;
                this.m_data[n] = this.m_data[n] + (long)del;
            }
        }
    }
}

