/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.util;

public class SubArray<T> {
    private final T[] m_data;
    private final int m_beg;
    private final int m_end;
    private final int m_inc;

    SubArray() {
        this.m_data = null;
        this.m_beg = 0;
        this.m_end = 0;
        this.m_inc = 1;
    }

    public SubArray(T[] data) {
        this.m_data = data;
        this.m_beg = 0;
        this.m_end = data.length;
        this.m_inc = 1;
    }

    public SubArray(T[] data, int beg, int end, int inc) {
        this.m_data = data;
        this.m_beg = beg;
        this.m_end = end;
        this.m_inc = inc;
    }

    public void copy(SubArray<T> a) {
        int tcur = this.m_beg;
        int scur = a.m_beg;
        if (this.m_inc == 1 && a.m_inc == 1) {
            while (tcur != this.m_end) {
                this.m_data[tcur++] = a.m_data[scur++];
            }
        } else {
            while (tcur != this.m_end) {
                this.m_data[tcur] = a.m_data[scur];
                tcur += this.m_inc;
                scur += a.m_inc;
            }
        }
    }

    public T get(int idx) {
        return this.m_data[this.m_beg + idx * this.m_inc];
    }

    public int getLength() {
        return this.m_inc == 0 ? 0 : (this.m_end - this.m_beg) / this.m_inc;
    }

    public boolean isEmpty() {
        for (int i = this.m_beg; i != this.m_end; i += this.m_inc) {
            if (this.m_data[i] == null) continue;
            return false;
        }
        return true;
    }

    public SubArray<T> range(int i0, int i1) {
        return new SubArray<T>(this.m_data, this.m_beg + i0 * this.m_inc, this.m_beg + i1 * this.m_inc, this.m_inc);
    }

    public void set(int idx, T value) {
        this.m_data[this.m_beg + idx * this.m_inc] = value;
    }

    public void set(T tval) {
        if (this.m_inc == 1) {
            while (cur != this.m_end) {
                this.m_data[cur++] = tval;
            }
        } else {
            for (cur = this.m_beg; cur != this.m_end; cur += this.m_inc) {
                this.m_data[cur] = tval;
            }
        }
    }
}

