/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.regression;

import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDataSupplier;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;

public abstract class TsVariable
implements ITsVariable {
    private final String id;
    private final TsData data;
    private final String desc;

    protected static TsData data(String id, ModellingContext context) {
        TsDataSupplier supplier = context.getTsVariable(id);
        if (supplier == null) {
            return null;
        }
        return supplier.get();
    }

    protected TsVariable(String id, TsData data, String desc) {
        this.id = id;
        this.data = data;
        this.desc = desc;
    }

    @Override
    public <D extends TimeSeriesDomain<?>> String description(D context) {
        return this.desc == null ? this.id : this.desc;
    }

    public String getId() {
        return this.id;
    }

    public TsData getData() {
        return this.data;
    }

    protected boolean equals(TsVariable obj) {
        return this.id.equals(obj.id);
    }

    protected int hash() {
        return this.id.hashCode();
    }

    @Override
    public int dim() {
        return 1;
    }
}

