/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.regression;

import jdplus.toolkit.base.api.timeseries.regression.ModifiedTsVariable;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class TsLags
implements ModifiedTsVariable.Modifier {
    private final int firstLag;
    private final int lastLag;

    public TsLags(int firstlag, int lastlag) {
        if (lastlag < firstlag) {
            throw new IllegalArgumentException();
        }
        this.firstLag = firstlag;
        this.lastLag = lastlag;
    }

    @Override
    public int dim() {
        return this.getLagsCount();
    }

    public int getLagsCount() {
        return this.lastLag - this.firstLag + 1;
    }

    @Override
    public String description() {
        if (this.firstLag == 0 && this.lastLag == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        if (this.firstLag < 0) {
            builder.append('+');
        }
        builder.append(-this.firstLag);
        if (this.lastLag != this.firstLag) {
            builder.append(':');
            if (this.lastLag < 0) {
                builder.append('+');
            }
            builder.append(-this.lastLag);
        }
        return builder.append(']').toString();
    }

    @Override
    public String description(int idx) {
        int lag = this.firstLag + idx;
        if (lag == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        if (lag < 0) {
            builder.append('+');
        }
        builder.append(-lag).append(']');
        return builder.toString();
    }

    @Generated
    public int getFirstLag() {
        return this.firstLag;
    }

    @Generated
    public int getLastLag() {
        return this.lastLag;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TsLags)) {
            return false;
        }
        TsLags other = (TsLags)o;
        if (this.getFirstLag() != other.getFirstLag()) {
            return false;
        }
        return this.getLastLag() == other.getLastLag();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getFirstLag();
        result = result * 59 + this.getLastLag();
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "TsLags(firstLag=" + this.getFirstLag() + ", lastLag=" + this.getLastLag() + ")";
    }
}

