/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.regression;

import java.util.List;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.api.timeseries.regression.ModellingContext;
import jdplus.toolkit.base.api.timeseries.regression.ModifiedTsVariable;
import jdplus.toolkit.base.api.timeseries.regression.TsLag;
import jdplus.toolkit.base.api.timeseries.regression.UserVariable;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class TsContextVariable
implements ITsVariable {
    @NonNull
    private final String id;
    private final int lag;

    public TsContextVariable(String id) {
        this.id = id;
        this.lag = 0;
    }

    public TsContextVariable(String id, int lag) {
        this.id = id;
        this.lag = lag;
    }

    public TsContextVariable withId(String nid) {
        if (this.id.equals(nid)) {
            return this;
        }
        return new TsContextVariable(nid, this.lag);
    }

    public TsContextVariable withLag(int nlag) {
        if (nlag == this.lag) {
            return this;
        }
        return new TsContextVariable(this.id, nlag);
    }

    public boolean isLag() {
        return this.lag != 0;
    }

    @Override
    public int dim() {
        return 1;
    }

    @Override
    public <D extends TimeSeriesDomain<?>> String description(D context) {
        return this.id;
    }

    @Override
    public <D extends TimeSeriesDomain<?>> String description(int idx, D context) {
        if (this.isLag()) {
            StringBuilder builder = new StringBuilder();
            builder.append(this.id);
            if (this.lag < 0) {
                builder.append('+').append(-this.lag).append(')');
            } else {
                builder.append('-').append(this.lag).append(')');
            }
            return builder.toString();
        }
        return this.id;
    }

    public ITsVariable instantiateFrom(ModellingContext context, String desc) {
        UserVariable var = UserVariable.of(this.id, desc, context);
        if (var != null && this.isLag()) {
            return ModifiedTsVariable.builder().variable(var).modifier(new TsLag(this.lag)).build();
        }
        return var;
    }

    public static TsContextVariable of(ITsVariable var) {
        Object object;
        ModifiedTsVariable mvar;
        List<ModifiedTsVariable.Modifier> modifiers;
        if (var instanceof TsContextVariable) {
            TsContextVariable tvar = (TsContextVariable)var;
            return tvar;
        }
        if (var instanceof UserVariable) {
            UserVariable user = (UserVariable)var;
            return new TsContextVariable(user.getId(), 0);
        }
        if (var instanceof ModifiedTsVariable && (modifiers = (mvar = (ModifiedTsVariable)var).getModifiers()).size() == 1 && (object = modifiers.get(0)) instanceof TsLag) {
            TsLag lag = (TsLag)object;
            object = mvar.getVariable();
            if (object instanceof UserVariable) {
                UserVariable user = (UserVariable)object;
                return new TsContextVariable(user.getId(), lag.getLag());
            }
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        if (this.lag == 0) {
            return this.id;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.id).append('[');
        if (this.lag < 0) {
            builder.append('+');
        }
        builder.append(-this.lag);
        return builder.append(']').toString();
    }

    @NonNull
    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public int getLag() {
        return this.lag;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TsContextVariable)) {
            return false;
        }
        TsContextVariable other = (TsContextVariable)o;
        if (this.getLag() != other.getLag()) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLag();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }
}

