/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries.regression;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;

public interface IOutlier
extends ITsVariable {
    @Override
    default public int dim() {
        return 1;
    }

    @Override
    default public <D extends TimeSeriesDomain<?>> String description(D context) {
        String code = this.getCode();
        LocalDateTime pos = this.getPosition();
        StringBuilder builder = new StringBuilder();
        builder.append(code).append(" (");
        if (context == null || !(context instanceof TsDomain)) {
            builder.append(pos);
        } else {
            TsPeriod p = ((TsDomain)context).get(0);
            p = p.withDate(pos);
            builder.append(p.getStartAsShortString());
        }
        builder.append(')');
        return builder.toString();
    }

    public static <D extends TimeSeriesDomain<?>> String defaultName(String code, LocalDateTime pos, D context) {
        StringBuilder builder = new StringBuilder();
        builder.append(code).append(" (");
        if (context == null || !(context instanceof TsDomain)) {
            builder.append(pos);
        } else {
            TsPeriod p = ((TsDomain)context).get(0);
            p = p.withDate(pos);
            builder.append(p.start().toLocalDate().format(DateTimeFormatter.ISO_DATE));
        }
        builder.append(')');
        return builder.toString();
    }

    public static <D extends TimeSeriesDomain<?>> String defaultName(String code, TsPeriod pos) {
        StringBuilder builder = new StringBuilder();
        builder.append(code).append(" (");
        builder.append(pos.start().toLocalDate().format(DateTimeFormatter.ISO_DATE));
        builder.append(')');
        return builder.toString();
    }

    public String getCode();

    public LocalDateTime getPosition();
}

