/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.time.LocalDateTime;
import jdplus.toolkit.base.api.data.Range;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class TimeSelector {
    private static final TimeSelector ALL = new TimeSelector(SelectionType.All, LocalDateTime.MIN, LocalDateTime.MAX, 0, 0);
    private static final TimeSelector NONE = new TimeSelector(SelectionType.None, LocalDateTime.MIN, LocalDateTime.MAX, 0, 0);
    @NonNull
    private final SelectionType type;
    @NonNull
    private final LocalDateTime d0;
    @NonNull
    private final LocalDateTime d1;
    private final int n0;
    private final int n1;

    public static Builder builder() {
        return new Builder().type(SelectionType.All).d0(LocalDateTime.MIN).d1(LocalDateTime.MAX);
    }

    public static TimeSelector all() {
        return ALL;
    }

    public static TimeSelector between(@NonNull LocalDateTime start, @NonNull LocalDateTime end) {
        if (start == null) {
            throw new NullPointerException("start is marked non-null but is null");
        }
        if (end == null) {
            throw new NullPointerException("end is marked non-null but is null");
        }
        return new TimeSelector(SelectionType.Between, start, end, 0, 0);
    }

    public static TimeSelector between(@NonNull Range<LocalDateTime> range) {
        if (range == null) {
            throw new NullPointerException("range is marked non-null but is null");
        }
        return new TimeSelector(SelectionType.Between, range.start(), range.end(), 0, 0);
    }

    public static TimeSelector excluding(int n0, int n1) {
        return new TimeSelector(SelectionType.Excluding, LocalDateTime.MIN, LocalDateTime.MAX, n0, n1);
    }

    public static TimeSelector first(int n) {
        return new TimeSelector(SelectionType.First, LocalDateTime.MIN, LocalDateTime.MAX, n, 0);
    }

    public static TimeSelector from(@NonNull LocalDateTime d0) {
        if (d0 == null) {
            throw new NullPointerException("d0 is marked non-null but is null");
        }
        return new TimeSelector(SelectionType.From, d0, LocalDateTime.MAX, 0, 0);
    }

    public static TimeSelector last(int n) {
        return new TimeSelector(SelectionType.Last, LocalDateTime.MIN, LocalDateTime.MAX, 0, n);
    }

    public static TimeSelector none() {
        return NONE;
    }

    public static TimeSelector to(LocalDateTime d1) {
        return new TimeSelector(SelectionType.To, LocalDateTime.MIN, d1, 0, 0);
    }

    public String toString() {
        switch (this.type.ordinal()) {
            case 4: {
                return this.d0.toString() + " - " + this.d1.toString();
            }
            case 7: {
                if (this.n0 == 0 && this.n1 == 0) {
                    return "";
                }
                StringBuilder builder = new StringBuilder();
                builder.append("All but ");
                if (this.n0 != 0) {
                    builder.append("first ");
                    if (this.n0 > 1) {
                        builder.append(this.n0).append(" periods");
                    } else if (this.n0 > 0) {
                        builder.append("period");
                    } else if (this.n0 < -1) {
                        builder.append(-this.n0).append(" years");
                    } else if (this.n0 < 0) {
                        builder.append("year");
                    }
                    if (this.n1 != 0) {
                        builder.append(" and ");
                    }
                }
                if (this.n1 != 0) {
                    builder.append("last ");
                    if (this.n1 > 1) {
                        builder.append(this.n1).append(" periods");
                    } else if (this.n1 > 0) {
                        builder.append("period");
                    } else if (this.n1 < -1) {
                        builder.append(-this.n1).append(" years");
                    } else if (this.n1 < 0) {
                        builder.append("year");
                    }
                }
                return builder.toString();
            }
            case 6: {
                StringBuilder builder = new StringBuilder();
                if (this.n0 > 0) {
                    builder.append("first ");
                    if (this.n0 > 1) {
                        builder.append(this.n0).append(" periods");
                    } else {
                        builder.append("period");
                    }
                    if (this.n1 > 0) {
                        builder.append(" and ");
                    }
                }
                return builder.toString();
            }
            case 5: {
                StringBuilder builder = new StringBuilder();
                if (this.n1 > 0) {
                    builder.append("last ");
                    if (this.n1 > 1) {
                        builder.append(this.n1).append(" periods");
                    } else {
                        builder.append("period");
                    }
                }
                return builder.toString();
            }
            case 2: {
                return "From " + this.d0.toString();
            }
            case 3: {
                return "Until " + this.d1.toString();
            }
            case 1: {
                return "All";
            }
            case 0: {
                return "None";
            }
        }
        return "";
    }

    public String toDateString() {
        StringBuilder builder = new StringBuilder();
        switch (this.type.ordinal()) {
            case 4: {
                if (!this.d0.equals(LocalDateTime.MIN)) {
                    builder.append(this.d0.toLocalDate());
                }
                builder.append(" - ");
                if (!this.d1.equals(LocalDateTime.MAX)) {
                    builder.append(this.d1.toLocalDate().minusDays(1L));
                }
                return builder.toString();
            }
            case 7: {
                if (this.n0 == 0 && this.n1 == 0) {
                    return "";
                }
                builder.append("All but ");
                if (this.n0 != 0) {
                    builder.append("first ");
                    if (this.n0 > 1) {
                        builder.append(this.n0).append(" periods");
                    } else if (this.n0 > 0) {
                        builder.append("period");
                    } else if (this.n0 < -1) {
                        builder.append(-this.n0).append(" years");
                    } else if (this.n0 < 0) {
                        builder.append("year");
                    }
                    if (this.n1 != 0) {
                        builder.append(" and ");
                    }
                }
                if (this.n1 != 0) {
                    builder.append("last ");
                    if (this.n1 > 1) {
                        builder.append(this.n1).append(" periods");
                    } else if (this.n1 > 0) {
                        builder.append("period");
                    } else if (this.n1 < -1) {
                        builder.append(-this.n1).append(" years");
                    } else if (this.n1 < 0) {
                        builder.append("year");
                    }
                }
                return builder.toString();
            }
            case 6: {
                if (this.n0 > 0) {
                    builder.append("first ");
                    if (this.n0 > 1) {
                        builder.append(this.n0).append(" periods");
                    } else {
                        builder.append("period");
                    }
                    if (this.n1 > 0) {
                        builder.append(" and ");
                    }
                }
                return builder.toString();
            }
            case 5: {
                if (this.n1 > 0) {
                    builder.append("last ");
                    if (this.n1 > 1) {
                        builder.append(this.n1).append(" periods");
                    } else {
                        builder.append("period");
                    }
                }
                return builder.toString();
            }
            case 2: {
                builder.append("From ");
                if (!this.d0.equals(LocalDateTime.MIN)) {
                    builder.append(this.d0.toLocalDate());
                }
                return builder.toString();
            }
            case 3: {
                builder.append("Until ");
                if (!this.d1.equals(LocalDateTime.MAX)) {
                    builder.append(this.d1.toLocalDate().minusDays(1L));
                }
                return builder.toString();
            }
            case 1: {
                return "All";
            }
            case 0: {
                return "None";
            }
        }
        return "";
    }

    public boolean isAll() {
        return this.type == SelectionType.All;
    }

    public boolean isNone() {
        return this.type == SelectionType.None;
    }

    @Generated
    public @org.jspecify.annotations.NonNull Builder toBuilder() {
        return new Builder().type(this.type).d0(this.d0).d1(this.d1).n0(this.n0).n1(this.n1);
    }

    @NonNull
    @Generated
    public SelectionType getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public LocalDateTime getD0() {
        return this.d0;
    }

    @NonNull
    @Generated
    public LocalDateTime getD1() {
        return this.d1;
    }

    @Generated
    public int getN0() {
        return this.n0;
    }

    @Generated
    public int getN1() {
        return this.n1;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TimeSelector)) {
            return false;
        }
        TimeSelector other = (TimeSelector)o;
        if (this.getN0() != other.getN0()) {
            return false;
        }
        if (this.getN1() != other.getN1()) {
            return false;
        }
        SelectionType this$type = this.getType();
        SelectionType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        LocalDateTime this$d0 = this.getD0();
        LocalDateTime other$d0 = other.getD0();
        if (this$d0 == null ? other$d0 != null : !((Object)this$d0).equals(other$d0)) {
            return false;
        }
        LocalDateTime this$d1 = this.getD1();
        LocalDateTime other$d1 = other.getD1();
        return !(this$d1 == null ? other$d1 != null : !((Object)this$d1).equals(other$d1));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getN0();
        result = result * 59 + this.getN1();
        SelectionType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        LocalDateTime $d0 = this.getD0();
        result = result * 59 + ($d0 == null ? 43 : ((Object)$d0).hashCode());
        LocalDateTime $d1 = this.getD1();
        result = result * 59 + ($d1 == null ? 43 : ((Object)$d1).hashCode());
        return result;
    }

    @Generated
    private TimeSelector(@NonNull SelectionType type, @NonNull LocalDateTime d0, @NonNull LocalDateTime d1, int n0, int n1) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (d0 == null) {
            throw new NullPointerException("d0 is marked non-null but is null");
        }
        if (d1 == null) {
            throw new NullPointerException("d1 is marked non-null but is null");
        }
        this.type = type;
        this.d0 = d0;
        this.d1 = d1;
        this.n0 = n0;
        this.n1 = n1;
    }

    @Generated
    public static class Builder {
        @Generated
        private SelectionType type;
        @Generated
        private LocalDateTime d0;
        @Generated
        private LocalDateTime d1;
        @Generated
        private int n0;
        @Generated
        private int n1;

        @Generated
        Builder() {
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder type(@NonNull SelectionType type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder d0(@NonNull LocalDateTime d0) {
            if (d0 == null) {
                throw new NullPointerException("d0 is marked non-null but is null");
            }
            this.d0 = d0;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder d1(@NonNull LocalDateTime d1) {
            if (d1 == null) {
                throw new NullPointerException("d1 is marked non-null but is null");
            }
            this.d1 = d1;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder n0(int n0) {
            this.n0 = n0;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull Builder n1(int n1) {
            this.n1 = n1;
            return this;
        }

        @Generated
        public @org.jspecify.annotations.NonNull TimeSelector build() {
            return new TimeSelector(this.type, this.d0, this.d1, this.n0, this.n1);
        }

        @Generated
        public @org.jspecify.annotations.NonNull String toString() {
            return "TimeSelector.Builder(type=" + String.valueOf((Object)this.type) + ", d0=" + String.valueOf(this.d0) + ", d1=" + String.valueOf(this.d1) + ", n0=" + this.n0 + ", n1=" + this.n1 + ")";
        }
    }

    public static enum SelectionType {
        None,
        All,
        From,
        To,
        Between,
        Last,
        First,
        Excluding;

    }
}

