/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.timeseries;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Iterator;
import jdplus.toolkit.base.api.timeseries.CalendarPeriod;
import jdplus.toolkit.base.api.timeseries.TimeSelector;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class CalendarPeriods
implements TimeSeriesDomain<CalendarPeriod> {
    @NonNull
    private final CalendarPeriod[] periods;

    @Override
    public int length() {
        return this.periods.length;
    }

    @Override
    public CalendarPeriod get(int index) throws IndexOutOfBoundsException {
        return this.periods[index];
    }

    @Override
    public LocalDateTime start() {
        return this.periods[0].start();
    }

    @Override
    public LocalDateTime end() {
        return this.periods[this.periods.length - 1].end();
    }

    @Override
    public boolean contains(LocalDateTime date) {
        for (int pos = 0; pos < this.periods.length && !this.periods[pos].start().isAfter(date); ++pos) {
            if (!date.isBefore(this.periods[pos].end())) continue;
            return true;
        }
        return false;
    }

    @Override
    public int indexOf(LocalDateTime date) {
        int pos;
        for (pos = 0; pos < this.periods.length && !this.periods[pos].start().isAfter(date); ++pos) {
            if (!date.isBefore(this.periods[pos].end())) continue;
            return pos;
        }
        return -pos - 1;
    }

    @Override
    public int indexOf(CalendarPeriod period) {
        return Arrays.binarySearch(this.periods, period);
    }

    @Override
    public boolean contains(CalendarPeriod period) {
        return Arrays.binarySearch(this.periods, period) >= 0;
    }

    @Override
    public Iterator<CalendarPeriod> iterator() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public TimeSeriesDomain<CalendarPeriod> select(TimeSelector selector) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Generated
    private CalendarPeriods(@NonNull CalendarPeriod[] periods) {
        if (periods == null) {
            throw new NullPointerException("periods is marked non-null but is null");
        }
        this.periods = periods;
    }

    @Generated
    public static @org.jspecify.annotations.NonNull CalendarPeriods of(@NonNull CalendarPeriod[] periods) {
        if (periods == null) {
            throw new NullPointerException("periods is marked non-null but is null");
        }
        return new CalendarPeriods(periods);
    }

    @NonNull
    @Generated
    public CalendarPeriod[] getPeriods() {
        return this.periods;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CalendarPeriods)) {
            return false;
        }
        CalendarPeriods other = (CalendarPeriods)o;
        return Arrays.deepEquals(this.getPeriods(), other.getPeriods());
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getPeriods());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "CalendarPeriods(periods=" + Arrays.deepToString(this.getPeriods()) + ")";
    }
}

