/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.stats;

import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class StatisticalTest {
    private final double value;
    private final double pvalue;
    private final String description;

    public boolean isSignificant(double threshold) {
        return this.pvalue < threshold;
    }

    public boolean isValid() {
        return Double.isFinite(this.value) && Double.isFinite(this.pvalue);
    }

    @Generated
    public StatisticalTest(double value, double pvalue, String description) {
        this.value = value;
        this.pvalue = pvalue;
        this.description = description;
    }

    @Generated
    public double getValue() {
        return this.value;
    }

    @Generated
    public double getPvalue() {
        return this.pvalue;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StatisticalTest)) {
            return false;
        }
        StatisticalTest other = (StatisticalTest)o;
        if (Double.compare(this.getValue(), other.getValue()) != 0) {
            return false;
        }
        if (Double.compare(this.getPvalue(), other.getPvalue()) != 0) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        long $pvalue = Double.doubleToLongBits(this.getPvalue());
        result = result * 59 + (int)($pvalue >>> 32 ^ $pvalue);
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @Generated
    public @NonNull String toString() {
        return "StatisticalTest(value=" + this.getValue() + ", pvalue=" + this.getPvalue() + ", description=" + this.getDescription() + ")";
    }
}

