/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.processing;

import java.util.Map;
import java.util.UUID;
import jdplus.toolkit.base.api.information.Explorable;
import jdplus.toolkit.base.api.processing.ProcSpecification;
import jdplus.toolkit.base.api.processing.ProcessingStatus;
import jdplus.toolkit.base.api.util.Documented;
import lombok.NonNull;

public interface ProcDocument<S extends ProcSpecification, I, R extends Explorable>
extends Documented {
    public static final String INPUT = "input";
    public static final String SPEC = "specification";
    public static final String ALGORITHM = "algorithm";
    public static final String RESULTS = "results";
    public static final String METADATA = "metadata";
    public static final String ERROR = "@error";

    public I getInput();

    public S getSpecification();

    public ProcessingStatus getStatus();

    public R getResult();

    public void set(S var1, I var2);

    default public void set(S newSpec) {
        this.set(newSpec, this.getInput());
    }

    default public void set(I newInput) {
        this.set(this.getSpecification(), newInput);
    }

    public void setMetadata(Map<String, String> var1);

    public void updateMetadata(Map<String, String> var1);

    public ProcessingStatus process();

    @NonNull
    public UUID getKey();
}

