/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.modelling.regular;

import java.util.Arrays;
import jdplus.toolkit.base.api.data.Parameter;
import jdplus.toolkit.base.api.timeseries.calendars.LengthOfPeriodType;
import jdplus.toolkit.base.api.timeseries.calendars.TradingDaysType;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class TradingDaysSpec {
    public static final boolean DEF_ADJUST = false;
    public static final boolean DEF_SIMPLIFIED = true;
    private static final TradingDaysSpec NONE = new TradingDaysSpec(null, null, TradingDaysType.NONE, LengthOfPeriodType.None, false, false, true, 0, AutoMethod.UNUSED, 0.0, null, null);
    public static final double DEF_PTD = 0.01;
    private final String holidays;
    private final String[] userVariables;
    private final TradingDaysType tradingDaysType;
    private final LengthOfPeriodType lengthOfPeriodType;
    private final boolean test;
    private final boolean autoAdjust;
    private final boolean simplified;
    private final int stockTradingDays;
    private final AutoMethod automaticMethod;
    private final double probabilityForTest;
    private final Parameter[] tdCoefficients;
    private final Parameter lpCoefficient;

    public static TradingDaysSpec stockTradingDays(int w, boolean test) {
        return new TradingDaysSpec(null, null, TradingDaysType.TD7, LengthOfPeriodType.None, test, false, true, w, AutoMethod.UNUSED, 0.0, null, null);
    }

    public static TradingDaysSpec stockTradingDays(int w, @NonNull Parameter[] tdcoeff) {
        if (tdcoeff == null) {
            throw new NullPointerException("tdcoeff is marked non-null but is null");
        }
        if (tdcoeff.length != 6) {
            throw new IllegalArgumentException();
        }
        return new TradingDaysSpec(null, null, TradingDaysType.TD7, LengthOfPeriodType.None, false, false, true, w, AutoMethod.UNUSED, 0.0, tdcoeff, null);
    }

    public static TradingDaysSpec none() {
        return NONE;
    }

    public static TradingDaysSpec userDefined(@NonNull String[] vars, boolean test) {
        if (vars == null) {
            throw new NullPointerException("vars is marked non-null but is null");
        }
        return new TradingDaysSpec(null, vars, TradingDaysType.NONE, LengthOfPeriodType.None, test, false, true, 0, AutoMethod.UNUSED, 0.0, null, null);
    }

    public static TradingDaysSpec userDefined(@NonNull String[] vars, @NonNull Parameter[] coeff) {
        if (vars == null) {
            throw new NullPointerException("vars is marked non-null but is null");
        }
        if (coeff == null) {
            throw new NullPointerException("coeff is marked non-null but is null");
        }
        if (coeff.length != vars.length) {
            throw new IllegalArgumentException();
        }
        return new TradingDaysSpec(null, vars, TradingDaysType.NONE, LengthOfPeriodType.None, false, false, true, 0, AutoMethod.UNUSED, 0.0, coeff, null);
    }

    public static TradingDaysSpec automaticHolidays(String holidays, LengthOfPeriodType lp, AutoMethod automaticMethod, double probabilityForFTest, boolean autoadjust) {
        if (automaticMethod == AutoMethod.UNUSED) {
            throw new IllegalArgumentException();
        }
        return new TradingDaysSpec(holidays, null, TradingDaysType.TD7, lp, false, autoadjust, true, 0, automaticMethod, probabilityForFTest, null, null);
    }

    public static TradingDaysSpec automatic(LengthOfPeriodType lp, AutoMethod automaticMethod, double probabilityForFTest, boolean autoadjust) {
        if (automaticMethod == AutoMethod.UNUSED) {
            throw new IllegalArgumentException();
        }
        return new TradingDaysSpec(null, null, TradingDaysType.TD7, lp, false, autoadjust, true, 0, automaticMethod, probabilityForFTest, null, null);
    }

    public static TradingDaysSpec holidays(String holidays, TradingDaysType type, LengthOfPeriodType lp, boolean test, boolean autoadjust) {
        if (type == TradingDaysType.NONE) {
            throw new IllegalArgumentException();
        }
        return new TradingDaysSpec(holidays, null, type, lp, test, autoadjust, true, 0, AutoMethod.UNUSED, 0.0, null, null);
    }

    public static TradingDaysSpec holidays(String holidays, TradingDaysType type, LengthOfPeriodType lp, Parameter[] ctd, Parameter clp) {
        if (type == TradingDaysType.NONE) {
            throw new IllegalArgumentException();
        }
        return new TradingDaysSpec(holidays, null, type, lp, false, false, true, 0, AutoMethod.UNUSED, 0.0, ctd, clp);
    }

    public static TradingDaysSpec td(TradingDaysType type, LengthOfPeriodType lp, boolean test, boolean autoadjust) {
        if (type == TradingDaysType.NONE) {
            throw new IllegalArgumentException();
        }
        return new TradingDaysSpec(null, null, type, lp, test, autoadjust, true, 0, AutoMethod.UNUSED, 0.0, null, null);
    }

    public static TradingDaysSpec td(TradingDaysType type, LengthOfPeriodType lp, Parameter[] tdcoeff, Parameter lpcoeff) {
        if (type == TradingDaysType.NONE && lp == LengthOfPeriodType.None) {
            throw new IllegalArgumentException();
        }
        return new TradingDaysSpec(null, null, type, lp, false, false, true, 0, AutoMethod.UNUSED, 0.0, tdcoeff, lpcoeff);
    }

    public boolean isUsed() {
        return this.isAutomatic() || this.tradingDaysType != TradingDaysType.NONE || this.userVariables != null || this.stockTradingDays != 0;
    }

    public boolean isDefined() {
        return this.userVariables != null || this.stockTradingDays != 0 && !this.test || (this.lengthOfPeriodType != LengthOfPeriodType.None || this.tradingDaysType != TradingDaysType.NONE) && !this.test && this.automaticMethod == AutoMethod.UNUSED;
    }

    public boolean isAutomatic() {
        return this.automaticMethod != AutoMethod.UNUSED;
    }

    public boolean isStockTradingDays() {
        return this.stockTradingDays != 0;
    }

    public boolean isUserDefined() {
        return this.userVariables != null;
    }

    public boolean isDefaultTradingDays() {
        return this.userVariables == null && this.holidays == null && this.stockTradingDays == 0 && this.tradingDaysType != TradingDaysType.NONE;
    }

    public boolean isHolidays() {
        return this.holidays != null;
    }

    public boolean isValid() {
        if (this.isStockTradingDays() || this.isAutomatic()) {
            return true;
        }
        if (this.test) {
            return this.tradingDaysType != TradingDaysType.NONE && this.lengthOfPeriodType != LengthOfPeriodType.None;
        }
        return true;
    }

    public boolean isDefault() {
        return this.equals(NONE);
    }

    public TradingDaysSpec withCoefficients(Parameter[] tdc, Parameter lpc) {
        return new TradingDaysSpec(this.holidays, this.userVariables, this.tradingDaysType, this.lengthOfPeriodType, false, this.autoAdjust, this.simplified, this.stockTradingDays, AutoMethod.UNUSED, this.probabilityForTest, tdc, lpc);
    }

    public boolean hasFixedCoefficients() {
        return this.lpCoefficient != null && this.lpCoefficient.isFixed() || Parameter.hasFixedParameters(this.tdCoefficients);
    }

    @Generated
    public String getHolidays() {
        return this.holidays;
    }

    @Generated
    public String[] getUserVariables() {
        return this.userVariables;
    }

    @Generated
    public TradingDaysType getTradingDaysType() {
        return this.tradingDaysType;
    }

    @Generated
    public LengthOfPeriodType getLengthOfPeriodType() {
        return this.lengthOfPeriodType;
    }

    @Generated
    public boolean isTest() {
        return this.test;
    }

    @Generated
    public boolean isAutoAdjust() {
        return this.autoAdjust;
    }

    @Generated
    public boolean isSimplified() {
        return this.simplified;
    }

    @Generated
    public int getStockTradingDays() {
        return this.stockTradingDays;
    }

    @Generated
    public AutoMethod getAutomaticMethod() {
        return this.automaticMethod;
    }

    @Generated
    public double getProbabilityForTest() {
        return this.probabilityForTest;
    }

    @Generated
    public Parameter[] getTdCoefficients() {
        return this.tdCoefficients;
    }

    @Generated
    public Parameter getLpCoefficient() {
        return this.lpCoefficient;
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TradingDaysSpec)) {
            return false;
        }
        TradingDaysSpec other = (TradingDaysSpec)o;
        if (this.isTest() != other.isTest()) {
            return false;
        }
        if (this.isAutoAdjust() != other.isAutoAdjust()) {
            return false;
        }
        if (this.isSimplified() != other.isSimplified()) {
            return false;
        }
        if (this.getStockTradingDays() != other.getStockTradingDays()) {
            return false;
        }
        if (Double.compare(this.getProbabilityForTest(), other.getProbabilityForTest()) != 0) {
            return false;
        }
        String this$holidays = this.getHolidays();
        String other$holidays = other.getHolidays();
        if (this$holidays == null ? other$holidays != null : !this$holidays.equals(other$holidays)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getUserVariables(), other.getUserVariables())) {
            return false;
        }
        TradingDaysType this$tradingDaysType = this.getTradingDaysType();
        TradingDaysType other$tradingDaysType = other.getTradingDaysType();
        if (this$tradingDaysType == null ? other$tradingDaysType != null : !((Object)((Object)this$tradingDaysType)).equals((Object)other$tradingDaysType)) {
            return false;
        }
        LengthOfPeriodType this$lengthOfPeriodType = this.getLengthOfPeriodType();
        LengthOfPeriodType other$lengthOfPeriodType = other.getLengthOfPeriodType();
        if (this$lengthOfPeriodType == null ? other$lengthOfPeriodType != null : !((Object)((Object)this$lengthOfPeriodType)).equals((Object)other$lengthOfPeriodType)) {
            return false;
        }
        AutoMethod this$automaticMethod = this.getAutomaticMethod();
        AutoMethod other$automaticMethod = other.getAutomaticMethod();
        if (this$automaticMethod == null ? other$automaticMethod != null : !((Object)((Object)this$automaticMethod)).equals((Object)other$automaticMethod)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getTdCoefficients(), other.getTdCoefficients())) {
            return false;
        }
        Parameter this$lpCoefficient = this.getLpCoefficient();
        Parameter other$lpCoefficient = other.getLpCoefficient();
        return !(this$lpCoefficient == null ? other$lpCoefficient != null : !((Object)this$lpCoefficient).equals(other$lpCoefficient));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isTest() ? 79 : 97);
        result = result * 59 + (this.isAutoAdjust() ? 79 : 97);
        result = result * 59 + (this.isSimplified() ? 79 : 97);
        result = result * 59 + this.getStockTradingDays();
        long $probabilityForTest = Double.doubleToLongBits(this.getProbabilityForTest());
        result = result * 59 + (int)($probabilityForTest >>> 32 ^ $probabilityForTest);
        String $holidays = this.getHolidays();
        result = result * 59 + ($holidays == null ? 43 : $holidays.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getUserVariables());
        TradingDaysType $tradingDaysType = this.getTradingDaysType();
        result = result * 59 + ($tradingDaysType == null ? 43 : ((Object)((Object)$tradingDaysType)).hashCode());
        LengthOfPeriodType $lengthOfPeriodType = this.getLengthOfPeriodType();
        result = result * 59 + ($lengthOfPeriodType == null ? 43 : ((Object)((Object)$lengthOfPeriodType)).hashCode());
        AutoMethod $automaticMethod = this.getAutomaticMethod();
        result = result * 59 + ($automaticMethod == null ? 43 : ((Object)((Object)$automaticMethod)).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getTdCoefficients());
        Parameter $lpCoefficient = this.getLpCoefficient();
        result = result * 59 + ($lpCoefficient == null ? 43 : ((Object)$lpCoefficient).hashCode());
        return result;
    }

    @Generated
    public @org.jspecify.annotations.NonNull String toString() {
        return "TradingDaysSpec(holidays=" + this.getHolidays() + ", userVariables=" + Arrays.deepToString(this.getUserVariables()) + ", tradingDaysType=" + String.valueOf((Object)this.getTradingDaysType()) + ", lengthOfPeriodType=" + String.valueOf((Object)this.getLengthOfPeriodType()) + ", test=" + this.isTest() + ", autoAdjust=" + this.isAutoAdjust() + ", simplified=" + this.isSimplified() + ", stockTradingDays=" + this.getStockTradingDays() + ", automaticMethod=" + String.valueOf((Object)this.getAutomaticMethod()) + ", probabilityForTest=" + this.getProbabilityForTest() + ", tdCoefficients=" + Arrays.deepToString(this.getTdCoefficients()) + ", lpCoefficient=" + String.valueOf(this.getLpCoefficient()) + ")";
    }

    @Generated
    private TradingDaysSpec(String holidays, String[] userVariables, TradingDaysType tradingDaysType, LengthOfPeriodType lengthOfPeriodType, boolean test, boolean autoAdjust, boolean simplified, int stockTradingDays, AutoMethod automaticMethod, double probabilityForTest, Parameter[] tdCoefficients, Parameter lpCoefficient) {
        this.holidays = holidays;
        this.userVariables = userVariables;
        this.tradingDaysType = tradingDaysType;
        this.lengthOfPeriodType = lengthOfPeriodType;
        this.test = test;
        this.autoAdjust = autoAdjust;
        this.simplified = simplified;
        this.stockTradingDays = stockTradingDays;
        this.automaticMethod = automaticMethod;
        this.probabilityForTest = probabilityForTest;
        this.tdCoefficients = tdCoefficients;
        this.lpCoefficient = lpCoefficient;
    }

    public static enum AutoMethod {
        UNUSED,
        WALD,
        BIC,
        AIC;

    }
}

