/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.math.matrices;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.api.math.matrices.Matrix;

class LightSubMatrix
implements Matrix {
    private final Matrix core;
    private final int r0;
    private final int nr;
    private final int c0;
    private final int nc;

    LightSubMatrix(Matrix core, int r0, int nr, int c0, int nc) {
        this.core = core;
        this.r0 = r0;
        this.nr = nr;
        this.c0 = c0;
        this.nc = nc;
    }

    @Override
    public double get(int row, int column) throws IndexOutOfBoundsException {
        if (row < 0 || row >= this.nr || column < 0 || column >= this.nc) {
            throw new IndexOutOfBoundsException();
        }
        return this.core.get(row + this.r0, column + this.c0);
    }

    @Override
    public DoubleSeq row(int irow) {
        if (irow < 0 || irow >= this.nr) {
            throw new IndexOutOfBoundsException();
        }
        return this.core.row(this.r0 + irow).extract(this.c0, this.nc);
    }

    @Override
    public DoubleSeq column(int icolumn) {
        if (icolumn < 0 || icolumn >= this.nc) {
            throw new IndexOutOfBoundsException();
        }
        return this.core.column(this.c0 + icolumn).extract(this.r0, this.nr);
    }

    @Override
    public int getColumnsCount() {
        return this.nc;
    }

    @Override
    public int getRowsCount() {
        return this.nr;
    }

    @Override
    public DoubleSeq diagonal() {
        DoubleSeq d = this.core.subDiagonal(this.c0 - this.r0);
        int start = Math.min(this.r0, this.c0);
        int n = Math.min(this.nr, this.nc);
        return d.extract(start, n);
    }

    @Override
    public DoubleSeq subDiagonal(int pos) {
        int n;
        if (pos > this.nc || pos < -this.nr) {
            return Doubles.EMPTY;
        }
        int del = this.c0 - this.r0;
        DoubleSeq d = this.core.subDiagonal(del + pos);
        int start = 0;
        if (pos > 0) {
            start = Math.min(this.r0, this.c0 + pos);
            n = Math.min(this.nr, this.nc - pos);
        } else if (pos < 0) {
            start = Math.min(this.c0, this.r0 + pos);
            n = Math.min(this.nr + pos, this.nc);
        } else {
            n = Math.min(this.nr, this.nc);
        }
        return d.extract(start, n);
    }

    public String toString() {
        return Matrix.format(this);
    }
}

