/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.information;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jdplus.toolkit.base.api.information.BasicInformationExtractor;
import jdplus.toolkit.base.api.information.InformationExtractor;
import jdplus.toolkit.base.api.information.InformationExtractorLoader;
import jdplus.toolkit.base.api.util.WildCards;
import lombok.Generated;

public final class InformationExtractors {
    static volatile Map<Class, List<InformationExtractor>> extractors;

    public static void reloadExtractors() {
        List<InformationExtractor> load = InformationExtractorLoader.load();
        HashMap<Class, List<InformationExtractor<Object>>> x = new HashMap<Class, List<InformationExtractor<Object>>>();
        load.forEach(cur -> {
            List all = (List)x.get(cur.getSourceClass());
            if (all == null) {
                ArrayList<InformationExtractor> list = new ArrayList<InformationExtractor>(4);
                list.add((InformationExtractor)cur);
                x.put(cur.getSourceClass(), list);
            } else {
                all.add(cur);
            }
        });
        Set keys = x.keySet();
        for (Class cl : keys) {
            List cur2 = (List)x.get(cl);
            cur2.sort((o1, o2) -> {
                int p1 = ((InformationExtractor)o1).getPriority();
                int p2 = ((InformationExtractor)o2).getPriority();
                return Integer.compare(p2, p1);
            });
            InformationExtractor last = (InformationExtractor)cur2.get(cur2.size() - 1);
            if (last.getPriority() == -1) {
                x.put(cl, Collections.singletonList(last));
                continue;
            }
            x.put(cl, Collections.unmodifiableList((List)x.get(cl)));
        }
        extractors = Collections.unmodifiableMap(x);
    }

    public static List<InformationExtractor> extractors(Class D) {
        List<InformationExtractor> all;
        if (extractors == null) {
            InformationExtractors.reloadExtractors();
        }
        if ((all = extractors.get(D)) == null) {
            return Collections.emptyList();
        }
        return all;
    }

    public static void fillDictionary(Class D, String prefix, Map dic, boolean compact) {
        List<InformationExtractor> all = InformationExtractors.extractors(D);
        for (InformationExtractor x : all) {
            x.fillDictionary(prefix, dic, compact);
        }
    }

    public static boolean contains(Class D, String id) {
        List<InformationExtractor> all = InformationExtractors.extractors(D);
        for (BasicInformationExtractor basicInformationExtractor : all) {
            if (!basicInformationExtractor.contains(id)) continue;
            return true;
        }
        return false;
    }

    public static <S, Q> Q getData(Class D, S source, String id, Class<Q> qclass) {
        List<InformationExtractor> all = InformationExtractors.extractors(D);
        for (BasicInformationExtractor basicInformationExtractor : all) {
            Q obj = basicInformationExtractor.getData(source, id, qclass);
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    public static <S, Q> void searchAll(Class D, S source, WildCards wc, Class<Q> qclass, Map<String, Q> map) {
        List<InformationExtractor> all = InformationExtractors.extractors(D);
        for (BasicInformationExtractor basicInformationExtractor : all) {
            basicInformationExtractor.searchAll(source, wc, qclass, map);
        }
    }

    @Generated
    private InformationExtractors() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

