/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.data;

import internal.toolkit.base.api.data.InternalBlockCursors;
import java.util.function.DoubleUnaryOperator;
import jdplus.toolkit.base.api.data.BaseSeqCursor;
import lombok.NonNull;

public interface DoubleSeqCursor
extends BaseSeqCursor {
    public double getAndNext() throws IndexOutOfBoundsException;

    @NonNull
    public static DoubleSeqCursor of(double @NonNull [] data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return DoubleSeqCursor.of(data, 0, 1);
    }

    @NonNull
    public static DoubleSeqCursor of(double @NonNull [] data, int pos, int inc) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return switch (inc) {
            case 1 -> new InternalBlockCursors.BlockP1DoubleSeqCursor(data, pos);
            case -1 -> new InternalBlockCursors.BlockM1DoubleSeqCursor(data, pos);
            default -> new InternalBlockCursors.BlockDoubleSeqCursor(data, inc, pos);
        };
    }

    public static interface OnMutable
    extends DoubleSeqCursor {
        public void setAndNext(double var1) throws IndexOutOfBoundsException;

        public void applyAndNext(DoubleUnaryOperator var1) throws IndexOutOfBoundsException;

        public static OnMutable of(double[] data, int pos, int inc) {
            return switch (inc) {
                case 1 -> new InternalBlockCursors.BlockP1DoubleVectorCursor(data, pos);
                case -1 -> new InternalBlockCursors.BlockM1DoubleVectorCursor(data, pos);
                default -> new InternalBlockCursors.BlockDoubleVectorCursor(data, inc, pos);
            };
        }
    }
}

