/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.data;

import internal.toolkit.base.api.data.InternalDoubleSeq;
import internal.toolkit.base.api.data.InternalDoubleSeqCursor;
import internal.toolkit.base.api.data.InternalDoubleVector;
import internal.toolkit.base.api.data.InternalDoubleVectorCursor;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntUnaryOperator;
import java.util.stream.DoubleStream;
import jdplus.toolkit.base.api.data.BaseSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.api.data.DoublesMath;
import jdplus.toolkit.base.api.data.Interval;
import jdplus.toolkit.base.api.util.IntList;
import jdplus.toolkit.base.api.util.function.BiDoublePredicate;
import jdplus.toolkit.base.api.util.function.IntDoubleConsumer;
import lombok.NonNull;

public interface DoubleSeq
extends BaseSeq {
    public static final double[] EMPTYARRAY = new double[0];

    public double get(int var1) throws IndexOutOfBoundsException;

    @Override
    @NonNull
    default public DoubleSeqCursor cursor() {
        return new InternalDoubleSeqCursor.DefaultDoubleSeqCursor<DoubleSeq>(this);
    }

    default public void copyTo(double @NonNull [] buffer, int offset) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        InternalDoubleSeq.copyToByCursor(this, buffer, offset);
    }

    default public double @NonNull [] toArray() {
        return InternalDoubleSeq.toArrayByCursor(this);
    }

    @NonNull
    default public DoubleStream stream() {
        return InternalDoubleSeq.stream(this);
    }

    default public void forEach(@NonNull DoubleConsumer action) {
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        InternalDoubleSeq.forEach(this, action);
    }

    default public boolean allMatch(@NonNull DoublePredicate pred) {
        if (pred == null) {
            throw new NullPointerException("pred is marked non-null but is null");
        }
        return InternalDoubleSeq.allMatchByCursor(this, pred);
    }

    default public boolean allMatch(@NonNull DoubleSeq seq, @NonNull BiDoublePredicate pred) {
        if (seq == null) {
            throw new NullPointerException("seq is marked non-null but is null");
        }
        if (pred == null) {
            throw new NullPointerException("pred is marked non-null but is null");
        }
        return InternalDoubleSeq.allMatchByCursor(this, seq, pred);
    }

    default public boolean anyMatch(@NonNull DoublePredicate pred) {
        if (pred == null) {
            throw new NullPointerException("pred is marked non-null but is null");
        }
        return InternalDoubleSeq.anyMatchByCursor(this, pred);
    }

    default public double reduce(double initial, @NonNull DoubleBinaryOperator fn) {
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        return InternalDoubleSeq.reduceByCursor(this, initial, fn);
    }

    default public int indexOf(@NonNull DoublePredicate pred) {
        if (pred == null) {
            throw new NullPointerException("pred is marked non-null but is null");
        }
        return InternalDoubleSeq.firstIndexOfByCursor(this, pred);
    }

    default public int lastIndexOf(@NonNull DoublePredicate pred) {
        if (pred == null) {
            throw new NullPointerException("pred is marked non-null but is null");
        }
        return InternalDoubleSeq.lastIndexOf(this, pred);
    }

    default public int count(DoublePredicate pred) {
        return InternalDoubleSeq.countByCursor(this, pred);
    }

    @NonNull
    default public DoubleSeq map(@NonNull DoubleUnaryOperator fn) {
        if (fn == null) {
            throw new NullPointerException("fn is marked non-null but is null");
        }
        return DoubleSeq.onMapping(this.length(), i -> fn.applyAsDouble(this.get(i)));
    }

    @NonNull
    default public DoubleSeq map(int length, @NonNull IntUnaryOperator indexMapper) {
        if (indexMapper == null) {
            throw new NullPointerException("indexMapper is marked non-null but is null");
        }
        return DoubleSeq.onMapping(length, i -> this.get(indexMapper.applyAsInt(i)));
    }

    @NonNull
    default public DoubleSeq extract(int start, int length) {
        if (length == -1) {
            length = this.length() - start;
        }
        return this.map(length, i -> start + i);
    }

    @NonNull
    default public DoubleSeq extract(int start, int length, int increment) {
        if (length == -1) {
            length = increment > 0 ? 1 + (this.length() - start - 1) / increment : (start == 0 ? 1 : 1 - start / increment);
        }
        return this.map(length, i -> start + i * increment);
    }

    default public DoubleSeq drop(int beg, int end) {
        return this.extract(beg, this.length() - beg - end);
    }

    default public DoubleSeq range(int beg, int end) {
        return end <= beg ? this.map(0, i -> -1) : this.extract(beg, end - beg);
    }

    default public DoubleSeq cleanExtremities() {
        int first = this.indexOf(Double::isFinite);
        if (first == -1) {
            return Doubles.EMPTY;
        }
        int last = 1 + this.lastIndexOf(Double::isFinite);
        if (first == 0 && last == this.length()) {
            return this;
        }
        return this.range(first, last);
    }

    default public DoubleSeq reverse() {
        int n = this.length();
        return this.map(n, i -> n - 1 - i);
    }

    default public int[] search(DoublePredicate pred) {
        IntList list = new IntList();
        int n = this.length();
        DoubleSeqCursor cell = this.cursor();
        for (int j = 0; j < n; ++j) {
            if (!pred.test(cell.getAndNext())) continue;
            list.add(j);
        }
        return list.toArray();
    }

    default public int search(DoublePredicate pred, int[] first) {
        int n = this.length();
        DoubleSeqCursor cell = this.cursor();
        int cur = 0;
        for (int j = 0; j < n; ++j) {
            if (!pred.test(cell.getAndNext())) continue;
            first[cur++] = j;
            if (cur != first.length) continue;
            return cur;
        }
        return cur;
    }

    default public DoubleSeq fn(DoubleUnaryOperator fn) {
        double[] safeArray = this.toArray();
        for (int i = 0; i < safeArray.length; ++i) {
            safeArray[i] = fn.applyAsDouble(safeArray[i]);
        }
        return Doubles.ofInternal(safeArray);
    }

    default public DoubleSeq fn(DoubleSeq y, DoubleBinaryOperator fn) {
        double[] safeArray = this.toArray();
        DoubleSeqCursor ycur = y.cursor();
        for (int i = 0; i < safeArray.length; ++i) {
            safeArray[i] = fn.applyAsDouble(safeArray[i], ycur.getAndNext());
        }
        return Doubles.ofInternal(safeArray);
    }

    default public DoubleSeq fn(int lag, DoubleBinaryOperator fn) {
        int n = this.length() - lag;
        if (n <= 0) {
            return DoubleSeq.empty();
        }
        double[] safeArray = new double[n];
        if (lag == 1) {
            DoubleSeqCursor cursor = this.cursor();
            double prev = cursor.getAndNext();
            for (int i = 0; i < n; ++i) {
                double next = cursor.getAndNext();
                safeArray[i] = fn.applyAsDouble(prev, next);
                prev = next;
            }
        } else {
            for (int j = 0; j < lag; ++j) {
                double prev = this.get(j);
                for (int i = j; i < n; i += lag) {
                    double next = this.get(i + lag);
                    safeArray[i] = fn.applyAsDouble(prev, next);
                    prev = next;
                }
            }
        }
        return Doubles.ofInternal(safeArray);
    }

    default public DoubleSeq extend(int nbeg, int nend) {
        int i;
        int n = this.length() + nbeg + nend;
        double[] safeArray = new double[n];
        for (i = 0; i < nbeg; ++i) {
            safeArray[i] = Double.NaN;
        }
        this.copyTo(safeArray, nbeg);
        for (i = n - nend; i < n; ++i) {
            safeArray[i] = Double.NaN;
        }
        return Doubles.ofInternal(safeArray);
    }

    default public DoubleSeq select(DoublePredicate pred) {
        double[] x = this.toArray();
        int cur = 0;
        for (int i = 0; i < x.length; ++i) {
            if (!pred.test(x[i])) continue;
            if (cur < i) {
                x[cur] = x[i];
            }
            ++cur;
        }
        if (cur == x.length) {
            return Doubles.ofInternal(x);
        }
        double[] xc = new double[cur];
        System.arraycopy(x, 0, xc, 0, cur);
        return Doubles.ofInternal(xc);
    }

    default public DoubleSeq select(IntList selection) {
        if (selection == null) {
            return this;
        }
        int[] sel = selection.toArray();
        return Doubles.of(sel.length, i -> this.get(sel[i]));
    }

    default public DoubleSeq op(DoubleSeq b, DoubleBinaryOperator op) {
        double[] safeArray = this.toArray();
        DoubleSeqCursor cursor = b.cursor();
        for (int i = 0; i < safeArray.length; ++i) {
            safeArray[i] = op.applyAsDouble(safeArray[i], cursor.getAndNext());
        }
        return Doubles.ofInternal(safeArray);
    }

    default public DoubleSeq plus(double del) {
        if (del == 0.0) {
            return this;
        }
        double[] safeArray = this.toArray();
        int i = 0;
        while (i < safeArray.length) {
            int n = i++;
            safeArray[n] = safeArray[n] + del;
        }
        return Doubles.ofInternal(safeArray);
    }

    default public DoubleSeq times(double factor) {
        if (factor == 1.0) {
            return this;
        }
        if (factor == 0.0) {
            return DoubleSeq.onMapping(this.length(), i -> 0.0);
        }
        double[] safeArray = this.toArray();
        if (factor == -1.0) {
            for (int i2 = 0; i2 < safeArray.length; ++i2) {
                safeArray[i2] = -safeArray[i2];
            }
        } else {
            int i3 = 0;
            while (i3 < safeArray.length) {
                int n = i3++;
                safeArray[n] = safeArray[n] * factor;
            }
        }
        return Doubles.ofInternal(safeArray);
    }

    default public DoubleSeq fastOp(DoubleUnaryOperator op) {
        int n = this.length();
        return DoubleSeq.onMapping(n, i -> op.applyAsDouble(this.get(i)));
    }

    default public DoubleSeq fastOp(DoubleSeq b, DoubleBinaryOperator op) {
        int n = this.length();
        return DoubleSeq.onMapping(n, i -> op.applyAsDouble(this.get(i), b.get(i)));
    }

    default public DoubleSeq commit() {
        return Doubles.ofInternal(this.toArray());
    }

    default public double sum() {
        return DoublesMath.sum(this);
    }

    default public double average() {
        return DoublesMath.average(this);
    }

    default public double ssq() {
        return DoublesMath.ssq(this);
    }

    default public double ssqc(double mean) {
        return DoublesMath.ssqc(this, mean);
    }

    default public double sumWithMissing() {
        return DoublesMath.sumWithMissing(this);
    }

    default public double ssqWithMissing() {
        return DoublesMath.ssqWithMissing(this);
    }

    default public double ssqcWithMissing(double mean) {
        return DoublesMath.ssqcWithMissing(this, mean);
    }

    default public double averageWithMissing() {
        return DoublesMath.averageWithMissing(this);
    }

    default public double norm1() {
        return DoublesMath.norm1(this);
    }

    default public double norm2() {
        return DoublesMath.norm2(this);
    }

    default public double fastNorm2() {
        return DoublesMath.fastNorm2(this);
    }

    default public double normInf() {
        return DoublesMath.normInf(this);
    }

    default public double max() {
        int n = this.length();
        DoubleSeqCursor cursor = this.cursor();
        double max = Double.NaN;
        for (int i = 0; i < n; ++i) {
            double x = cursor.getAndNext();
            if (Double.isNaN(x)) continue;
            if (Double.isNaN(max)) {
                max = x;
                continue;
            }
            if (!(x > max)) continue;
            max = x;
        }
        return max;
    }

    default public double min() {
        int n = this.length();
        DoubleSeqCursor cursor = this.cursor();
        double min = Double.NaN;
        for (int i = 0; i < n; ++i) {
            double x = cursor.getAndNext();
            if (Double.isNaN(x)) continue;
            if (Double.isNaN(min)) {
                min = x;
                continue;
            }
            if (!(x < min)) continue;
            min = x;
        }
        return min;
    }

    default public Interval range() {
        int n = this.length();
        DoubleSeqCursor cursor = this.cursor();
        double min = Double.NaN;
        double max = Double.NaN;
        for (int i = 0; i < n; ++i) {
            double x = cursor.getAndNext();
            if (Double.isNaN(x)) continue;
            if (Double.isNaN(min)) {
                min = max = x;
                continue;
            }
            if (x < min) {
                min = x;
                continue;
            }
            if (!(x > max)) continue;
            max = x;
        }
        return new Interval(min, max);
    }

    default public int getRepeatCount() {
        return DoublesMath.getRepeatCount(this);
    }

    default public double dot(DoubleSeq data) {
        return DoublesMath.dot(this, data);
    }

    default public double jdot(DoubleSeq data, int pos) {
        return DoublesMath.jdot(this, data, pos);
    }

    default public double distance(DoubleSeq data) {
        return DoublesMath.distance(this, data);
    }

    default public DoubleSeq removeMean() {
        return DoublesMath.removeMean(this);
    }

    default public DoubleSeq delta(int lag) {
        return DoublesMath.delta(this, lag);
    }

    default public DoubleSeq delta(int lag, int pow) {
        return DoublesMath.delta(this, lag, pow);
    }

    default public DoubleSeq log() {
        return this.fn(Math::log);
    }

    default public DoubleSeq exp() {
        return this.fn(Math::exp);
    }

    default public DoubleSeq sqrt() {
        return this.fn(Math::sqrt);
    }

    default public boolean hasSameContentAs(DoubleSeq that) {
        return InternalDoubleSeq.hasSameContentAs(this, that);
    }

    public static int getHashCode(DoubleSeq values) {
        int result = 1;
        for (int i = 0; i < values.length(); ++i) {
            long bits = Double.doubleToLongBits(values.get(i));
            result = 31 * result + (int)(bits ^ bits >>> 32);
        }
        return result;
    }

    public static boolean equals(double a, double b, double epsilon) {
        return a > b ? a - epsilon <= b : b - epsilon <= a;
    }

    public static String format(DoubleSeq rd) {
        StringBuilder builder = new StringBuilder();
        int n = rd.length();
        if (n > 0) {
            builder.append(rd.get(0));
            for (int i = 1; i < n; ++i) {
                builder.append('\t').append(rd.get(i));
            }
        }
        return builder.toString();
    }

    public static String format(DoubleSeq rd, String fmt) {
        StringBuilder builder;
        block4: {
            builder = new StringBuilder();
            int n = rd.length();
            if (n <= 0) break block4;
            if (fmt != null) {
                DecimalFormat df = new DecimalFormat(fmt, DecimalFormatSymbols.getInstance(Locale.ROOT));
                DoubleSeqCursor cursor = rd.cursor();
                builder.append(df.format(cursor.getAndNext()));
                for (int i = 1; i < n; ++i) {
                    builder.append('\t').append(df.format(cursor.getAndNext()));
                }
            } else {
                builder.append(rd.get(0));
                for (int i = 1; i < n; ++i) {
                    builder.append('\t').append(rd.get(i));
                }
            }
        }
        return builder.toString();
    }

    public static String format(DoubleSeq rd, DecimalFormat fmt) {
        StringBuilder builder = new StringBuilder();
        int n = rd.length();
        if (n > 0) {
            DoubleSeqCursor cursor = rd.cursor();
            builder.append(fmt.format(cursor.getAndNext()));
            for (int i = 1; i < n; ++i) {
                builder.append('\t').append(fmt.format(cursor.getAndNext()));
            }
        }
        return builder.toString();
    }

    public static double round(double r, int ndec) {
        if (ndec < 0) {
            throw new IllegalArgumentException("Negative rounding parameter");
        }
        double f = 1.0;
        for (int i = 0; i < ndec; ++i) {
            f *= 10.0;
        }
        if (Double.isFinite(r)) {
            double v = r;
            r = ndec > 0 ? (double)Math.round(v * f) / f : (double)Math.round(v);
        }
        return r;
    }

    @NonNull
    public static DoubleSeq of(double ... data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return Doubles.ofInternal(data);
    }

    @NonNull
    public static DoubleSeq of(double @NonNull [] data, int start, int len) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return new InternalDoubleSeq.SubDoubleSeq(data, start, len);
    }

    @NonNull
    public static DoubleSeq of(double @NonNull [] data, int start, int len, int inc) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        return new InternalDoubleSeq.RegularlySpacedDoubles(data, start, len, inc);
    }

    @NonNull
    public static DoubleSeq empty() {
        return Doubles.EMPTY;
    }

    @NonNull
    public static DoubleSeq zero() {
        return Doubles.ZERO;
    }

    @NonNull
    public static DoubleSeq one() {
        return Doubles.ONE;
    }

    @NonNull
    public static DoubleSeq onMapping(int length, @NonNull IntToDoubleFunction getter) {
        if (getter == null) {
            throw new NullPointerException("getter is marked non-null but is null");
        }
        return new InternalDoubleSeq.MappingDoubleSeq(length, getter);
    }

    @NonNull
    public static DoubleSeq pooled(@NonNull DoubleSeq[] seqs) {
        if (seqs == null) {
            throw new NullPointerException("seqs is marked non-null but is null");
        }
        if (seqs.length == 0) {
            return Doubles.EMPTY;
        }
        if (seqs.length == 1) {
            return seqs[0];
        }
        int csize = 0;
        for (int i = 0; i < seqs.length; ++i) {
            csize += seqs[i].length();
        }
        double[] all = new double[csize];
        int pos = 0;
        for (int i = 0; i < seqs.length; ++i) {
            seqs[i].copyTo(all, pos);
            pos += seqs[i].length();
        }
        return DoubleSeq.of(all);
    }

    public static interface Mutable
    extends DoubleSeq {
        public void set(int var1, double var2) throws IndexOutOfBoundsException;

        default public void set(double value) {
            DoubleSeqCursor.OnMutable cur = this.cursor();
            int n = this.length();
            for (int i = 0; i < n; ++i) {
                cur.setAndNext(value);
            }
        }

        @Override
        default public @NonNull DoubleSeqCursor.OnMutable cursor() {
            return new InternalDoubleVectorCursor.DefaultDoubleVectorCursor<Mutable>(this);
        }

        @Override
        default public @NonNull Mutable map(int length, @NonNull IntUnaryOperator indexMapper) {
            if (indexMapper == null) {
                throw new NullPointerException("indexMapper is marked non-null but is null");
            }
            return Mutable.onMapping(length, i -> this.get(indexMapper.applyAsInt(i)), (i, v) -> this.set(indexMapper.applyAsInt(i), v));
        }

        @Override
        default public @NonNull Mutable extract(int start, int length) {
            return this.map(length, i -> start + i);
        }

        @Override
        default public @NonNull Mutable extract(int start, int length, int increment) {
            return this.map(length, i -> start + i * increment);
        }

        @Override
        default public Mutable drop(int beg, int end) {
            return this.extract(beg, this.length() - beg - end);
        }

        @Override
        default public Mutable range(int beg, int end) {
            return end <= beg ? this.map(0, i -> -1) : this.extract(beg, end - beg);
        }

        @Override
        default public Mutable reverse() {
            int n = this.length();
            return this.map(n, i -> n - 1 - i);
        }

        public static @NonNull Mutable empty() {
            return InternalDoubleVector.MultiDoubleVector.EMPTY;
        }

        public static @NonNull Mutable of(double @NonNull [] values) {
            if (values == null) {
                throw new NullPointerException("values is marked non-null but is null");
            }
            return new InternalDoubleVector.MultiDoubleVector(values);
        }

        public static @NonNull Mutable of(double @NonNull [] data, int start, int len, int inc) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            return new InternalDoubleVector.MappingDoubleVector(len, i -> data[start + i * inc], (i, x) -> {
                data[start + i * inc] = x;
            });
        }

        public static @NonNull Mutable onMapping(int length, @NonNull IntToDoubleFunction getter, @NonNull IntDoubleConsumer setter) {
            if (getter == null) {
                throw new NullPointerException("getter is marked non-null but is null");
            }
            if (setter == null) {
                throw new NullPointerException("setter is marked non-null but is null");
            }
            return new InternalDoubleVector.MappingDoubleVector(length, getter, setter);
        }

        default public void apply(int index, DoubleUnaryOperator fn) throws IndexOutOfBoundsException {
            this.set(index, fn.applyAsDouble(this.get(index)));
        }

        default public void set(DoubleSupplier fn) throws IndexOutOfBoundsException {
            DoubleSeqCursor.OnMutable cur = this.cursor();
            int n = this.length();
            for (int i = 0; i < n; ++i) {
                cur.setAndNext(fn.getAsDouble());
            }
        }

        default public void set(IntToDoubleFunction fn) throws IndexOutOfBoundsException {
            DoubleSeqCursor.OnMutable cur = this.cursor();
            int n = this.length();
            for (int i = 0; i < n; ++i) {
                cur.setAndNext(fn.applyAsDouble(i));
            }
        }

        default public void set(DoubleSeq z) throws IndexOutOfBoundsException {
            DoubleSeqCursor.OnMutable cur = this.cursor();
            DoubleSeqCursor zcur = z.cursor();
            int n = this.length();
            for (int i = 0; i < n; ++i) {
                cur.setAndNext(zcur.getAndNext());
            }
        }

        default public void set(DoubleSeq z, DoubleUnaryOperator fn) throws IndexOutOfBoundsException {
            DoubleSeqCursor.OnMutable cur = this.cursor();
            DoubleSeqCursor zcur = z.cursor();
            int n = this.length();
            for (int i = 0; i < n; ++i) {
                cur.setAndNext(fn.applyAsDouble(zcur.getAndNext()));
            }
        }

        default public void apply(DoubleUnaryOperator fn) {
            DoubleSeqCursor.OnMutable cursor = this.cursor();
            int n = this.length();
            for (int i = 0; i < n; ++i) {
                cursor.applyAndNext(fn);
            }
        }

        default public void apply(DoubleSeq z, DoubleBinaryOperator fn) throws IndexOutOfBoundsException {
            DoubleSeqCursor.OnMutable cur = this.cursor();
            DoubleSeqCursor zcur = z.cursor();
            int n = this.length();
            for (int i = 0; i < n; ++i) {
                cur.applyAndNext(x -> fn.applyAsDouble(x, zcur.getAndNext()));
            }
        }

        default public void setAY(double a, DoubleSeq y) throws IndexOutOfBoundsException {
            if (a == 1.0) {
                this.set(y);
            } else if (a == -1.0) {
                this.set(y, s -> -s);
            } else if (a != 0.0) {
                this.set(y, s -> a * s);
            }
        }

        default public void add(double a) {
            if (a != 0.0) {
                this.apply(x -> x + a);
            }
        }

        default public void sub(double a) {
            if (a != 0.0) {
                this.apply(x -> x - a);
            }
        }

        default public void chs() {
            this.apply(x -> -x);
        }

        default public void mul(double a) {
            if (a == 0.0) {
                this.set(0.0);
            } else if (a == -1.0) {
                this.chs();
            } else {
                this.apply(x -> x * a);
            }
        }

        default public void div(double a) {
            if (a == 0.0) {
                this.set(Double.NaN);
            } else if (a == -1.0) {
                this.chs();
            } else {
                this.apply(x -> x * a);
            }
        }

        default public void add(DoubleSeq y) throws IndexOutOfBoundsException {
            this.apply(y, (double a, double b) -> a + b);
        }

        default public void addAY(double a, DoubleSeq y) throws IndexOutOfBoundsException {
            if (a == 1.0) {
                this.add(y);
            } else if (a == -1.0) {
                this.sub(y);
            } else if (a != 0.0) {
                this.apply(y, (double s, double t) -> s + a * t);
            }
        }

        default public void sub(DoubleSeq y) throws IndexOutOfBoundsException {
            this.apply(y, (double a, double b) -> a - b);
        }

        default public void mul(DoubleSeq y) throws IndexOutOfBoundsException {
            this.apply(y, (double a, double b) -> a * b);
        }

        default public void div(DoubleSeq y) throws IndexOutOfBoundsException {
            this.apply(y, (double a, double b) -> a / b);
        }
    }
}

