/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.api.data;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.DoublePredicate;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.DoubleStream;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import lombok.NonNull;
import nbbrd.design.PrimitiveReplacementOf;

@PrimitiveReplacementOf(generic=List.class, primitive=double.class)
public final class DoubleList
implements DoubleSeq {
    private static final int DEFAULT_SIZE = 128;
    private double[] values;
    private int length;

    public DoubleList() {
        this(128);
    }

    public DoubleList(int initialCapacity) {
        this.values = new double[initialCapacity];
        this.length = 0;
    }

    public DoubleList(DoubleSeq list) {
        this.values = list.toArray();
        this.length = this.values.length;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public double get(int index) {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[index];
    }

    @Override
    public boolean isEmpty() {
        return this.length == 0;
    }

    @Override
    public double @NonNull [] toArray() {
        double[] result = new double[this.length];
        System.arraycopy(this.values, 0, result, 0, this.length);
        return result;
    }

    @Override
    public void copyTo(double @NonNull [] buffer, int offset) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        System.arraycopy(this.values, 0, buffer, offset, this.length);
    }

    @Override
    @NonNull
    public DoubleStream stream() {
        return Arrays.stream(this.values, 0, this.length);
    }

    @Override
    public  @NonNull DoubleSeqCursor.OnMutable cursor() {
        return new Cell();
    }

    public String toString() {
        return DoubleSeq.format(this);
    }

    public void add(int index, double value) {
        if (index > this.length) {
            throw new IndexOutOfBoundsException();
        }
        if (index == this.length) {
            this.add(value);
        } else {
            if (this.length == this.values.length) {
                this.growArray(this.length * 2);
            }
            System.arraycopy(this.values, index, this.values, index + 1, this.length - index);
            this.values[index] = value;
            ++this.length;
        }
    }

    public boolean add(double value) {
        if (this.length == this.values.length) {
            this.growArray(this.length * 2);
        }
        this.values[this.length++] = value;
        return true;
    }

    public boolean addAll(DoubleSeq c) {
        if (!c.isEmpty()) {
            if (this.length + c.length() > this.values.length) {
                this.growArray(this.length + c.length());
            }
            c.copyTo(this.values, this.length);
            this.length += c.length();
        }
        return true;
    }

    public boolean addAll(int index, DoubleSeq c) {
        if (index > this.length) {
            throw new IndexOutOfBoundsException();
        }
        if (!c.isEmpty()) {
            if (this.length + c.length() > this.values.length) {
                this.growArray(this.length + c.length());
            }
            System.arraycopy(this.values, index, this.values, index + c.length(), this.length - index);
            c.copyTo(this.values, index);
            this.length += c.length();
        }
        return true;
    }

    public void clear() {
        this.length = 0;
    }

    public boolean contains(double value) {
        return this.anyMatch(o -> o == value);
    }

    public boolean containsAll(DoubleSeq c) {
        return this != c ? this.allMatch(this::contains) : true;
    }

    public boolean equals(Object o) {
        boolean rval;
        boolean bl = rval = this == o;
        if (!rval && o != null && o.getClass() == this.getClass()) {
            DoubleList other = (DoubleList)o;
            if (other.length == this.length) {
                rval = true;
                for (int j = 0; rval && j < this.length; ++j) {
                    rval = this.values[j] == other.values[j];
                }
            }
        }
        return rval;
    }

    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    public int indexOf(double value) {
        return this.indexOf(o -> o == value);
    }

    public int lastIndexOf(double value) {
        return this.lastIndexOf(o -> o == value);
    }

    public double remove(int index) {
        if (index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        double rval = this.values[index];
        System.arraycopy(this.values, index + 1, this.values, index, this.length - index);
        --this.length;
        return rval;
    }

    public boolean removeValue(double o) {
        boolean rval = false;
        for (int j = 0; !rval && j < this.length; ++j) {
            if (o != this.values[j]) continue;
            if (j + 1 < this.length) {
                System.arraycopy(this.values, j + 1, this.values, j, this.length - j);
            }
            --this.length;
            rval = true;
        }
        return rval;
    }

    public boolean removeAll(DoubleSeq c) {
        boolean rval = false;
        for (int j = 0; j < c.length(); ++j) {
            if (!this.removeValue(c.get(j))) continue;
            rval = true;
        }
        return rval;
    }

    public boolean retainAll(DoubleList c) {
        boolean rval = false;
        int j = 0;
        while (j < this.length) {
            if (!c.contains(this.values[j])) {
                this.remove(j);
                rval = true;
                continue;
            }
            ++j;
        }
        return rval;
    }

    @Override
    public int size() {
        return this.length;
    }

    public double[] toArray(double[] a) {
        if (a.length == this.length) {
            System.arraycopy(this.values, 0, a, 0, this.length);
            return a;
        }
        return this.toArray();
    }

    public void replaceAll(DoubleUnaryOperator operator) {
        Objects.requireNonNull(operator);
        for (int i = 0; i < this.length; ++i) {
            this.values[i] = operator.applyAsDouble(this.values[i]);
        }
    }

    public void sort() {
        Arrays.sort(this.values, 0, this.length);
    }

    public boolean removeIf(DoublePredicate filter) {
        Objects.requireNonNull(filter);
        boolean removed = false;
        int i = 0;
        while (i < this.length) {
            if (filter.test(this.values[i])) {
                this.remove(i);
                removed = true;
                continue;
            }
            ++i;
        }
        return removed;
    }

    private void growArray(int newSize) {
        int size = newSize == this.values.length ? newSize + 1 : newSize;
        double[] newArray = new double[size];
        System.arraycopy(this.values, 0, newArray, 0, this.length);
        this.values = newArray;
    }

    private final class Cell
    implements DoubleSeqCursor.OnMutable {
        private int pos = 0;

        private Cell() {
        }

        @Override
        public double getAndNext() {
            return DoubleList.this.values[this.pos++];
        }

        @Override
        public void skip(int n) {
            this.pos += n;
        }

        @Override
        public void moveTo(int npos) {
            this.pos = npos;
        }

        @Override
        public void setAndNext(double newValue) throws IndexOutOfBoundsException {
            DoubleList.this.values[this.pos++] = newValue;
        }

        @Override
        public void applyAndNext(DoubleUnaryOperator fn) throws IndexOutOfBoundsException {
            DoubleList.this.values[this.pos] = fn.applyAsDouble(DoubleList.this.values[this.pos]);
            ++this.pos;
        }
    }
}

