/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.api.data;

import internal.toolkit.base.api.data.InternalBaseSeq;
import internal.toolkit.base.api.data.InternalDoubleSeqCursor;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoublePredicate;
import java.util.function.IntToDoubleFunction;
import java.util.stream.DoubleStream;
import java.util.stream.StreamSupport;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.DoubleSeqCursor;
import jdplus.toolkit.base.api.util.function.BiDoublePredicate;
import lombok.Generated;
import lombok.NonNull;
import org.jspecify.annotations.Nullable;

public final class InternalDoubleSeq {
    public static void forEach(DoubleSeq seq, DoubleConsumer action) {
        for (int i = 0; i < seq.length(); ++i) {
            action.accept(seq.get(i));
        }
    }

    public static Spliterator.OfDouble spliterator(DoubleSeq seq) {
        return Spliterators.spliterator(new DoubleIterator(seq), (long)seq.length(), 16);
    }

    public static void copyToByCursor(DoubleSeq seq, double[] buffer, int offset) {
        int n = seq.length();
        DoubleSeqCursor cursor = seq.cursor();
        for (int i = 0; i < n; ++i) {
            buffer[offset + i] = cursor.getAndNext();
        }
    }

    public static double[] toArrayByCursor(DoubleSeq seq) {
        double[] result = new double[seq.length()];
        DoubleSeqCursor cursor = seq.cursor();
        for (int i = 0; i < result.length; ++i) {
            result[i] = cursor.getAndNext();
        }
        return result;
    }

    public static DoubleStream stream(DoubleSeq seq) {
        return StreamSupport.doubleStream(InternalDoubleSeq.spliterator(seq), false);
    }

    public static boolean allMatchByCursor(DoubleSeq seq, DoublePredicate pred) {
        int n = seq.length();
        DoubleSeqCursor cursor = seq.cursor();
        for (int i = 0; i < n; ++i) {
            if (pred.test(cursor.getAndNext())) continue;
            return false;
        }
        return true;
    }

    public static boolean allMatchByCursor(DoubleSeq seq1, DoubleSeq seq2, BiDoublePredicate pred) {
        int n = seq1.length();
        DoubleSeqCursor cursor1 = seq1.cursor();
        DoubleSeqCursor cursor2 = seq2.cursor();
        for (int i = 0; i < n; ++i) {
            if (pred.test(cursor1.getAndNext(), cursor2.getAndNext())) continue;
            return false;
        }
        return true;
    }

    public static boolean anyMatchByCursor(DoubleSeq seq, DoublePredicate pred) {
        int n = seq.length();
        DoubleSeqCursor cursor = seq.cursor();
        for (int i = 0; i < n; ++i) {
            if (!pred.test(cursor.getAndNext())) continue;
            return true;
        }
        return false;
    }

    public static int firstIndexOfByCursor(DoubleSeq seq, DoublePredicate pred) {
        int n = seq.length();
        DoubleSeqCursor cursor = seq.cursor();
        for (int i = 0; i < n; ++i) {
            if (!pred.test(cursor.getAndNext())) continue;
            return i;
        }
        return n;
    }

    public static int lastIndexOf(DoubleSeq seq, DoublePredicate pred) {
        int n = seq.length();
        for (int i = n - 1; i >= 0; --i) {
            if (!pred.test(seq.get(i))) continue;
            return i;
        }
        return -1;
    }

    public static double reduceByCursor(DoubleSeq seq, double initial, DoubleBinaryOperator fn) {
        double result = initial;
        int n = seq.length();
        DoubleSeqCursor cursor = seq.cursor();
        for (int i = 0; i < n; ++i) {
            result = fn.applyAsDouble(result, cursor.getAndNext());
        }
        return result;
    }

    public static int countByCursor(DoubleSeq seq, DoublePredicate pred) {
        int n = seq.length();
        int result = 0;
        DoubleSeqCursor cursor = seq.cursor();
        for (int i = n - 1; i >= 0; --i) {
            if (!pred.test(cursor.getAndNext())) continue;
            ++result;
        }
        return result;
    }

    public static boolean hasSameContentAs(DoubleSeq left, DoubleSeq that) {
        return left == that || left.length() == that.length() && left.allMatch(that, InternalDoubleSeq::isSameValue);
    }

    private static boolean isSameValue(double left, double right) {
        return Double.doubleToLongBits(left) == Double.doubleToLongBits(right);
    }

    @Generated
    private InternalDoubleSeq() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static final class DoubleIterator
    implements PrimitiveIterator.OfDouble {
        private final DoubleSeq seq;
        private int cur = 0;

        @Override
        public boolean hasNext() {
            return this.cur < this.seq.length();
        }

        @Override
        public double nextDouble() {
            if (this.hasNext()) {
                return this.seq.get(this.cur++);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void forEachRemaining(DoubleConsumer block) {
            while (this.cur < this.seq.length()) {
                block.accept(this.seq.get(this.cur));
                ++this.cur;
            }
        }

        @Generated
        public DoubleIterator(DoubleSeq seq) {
            this.seq = seq;
        }
    }

    public static final class RegularlySpacedDoubles
    implements DoubleSeq {
        private final double[] data;
        private final int beg;
        private final int len;
        private final int inc;

        @Override
        @NonNull
        public DoubleSeqCursor cursor() {
            return new Cell();
        }

        @Override
        public double get(int idx) {
            return this.data[this.beg + idx * this.inc];
        }

        @Override
        public int length() {
            return this.len;
        }

        @Override
        public double @NonNull [] toArray() {
            double[] ndata = new double[this.len];
            int i = 0;
            int j = this.beg;
            while (i < this.len) {
                ndata[i] = this.data[j];
                ++i;
                j += this.inc;
            }
            return ndata;
        }

        public String toString() {
            return DoubleSeq.format(this);
        }

        @Generated
        public RegularlySpacedDoubles(double[] data, int beg, int len, int inc) {
            this.data = data;
            this.beg = beg;
            this.len = len;
            this.inc = inc;
        }

        private final class Cell
        implements DoubleSeqCursor {
            private int pos;

            private Cell() {
                this.pos = RegularlySpacedDoubles.this.beg;
            }

            @Override
            public double getAndNext() {
                double val = RegularlySpacedDoubles.this.data[this.pos];
                this.pos += RegularlySpacedDoubles.this.inc;
                return val;
            }

            @Override
            public void skip(int n) {
                this.pos += n * RegularlySpacedDoubles.this.inc;
            }

            @Override
            public void moveTo(int npos) {
                this.pos = RegularlySpacedDoubles.this.beg + npos * RegularlySpacedDoubles.this.inc;
            }
        }
    }

    public static class MappingDoubleSeq
    extends InternalBaseSeq.MappingBaseSeq
    implements DoubleSeq {
        protected final IntToDoubleFunction getter;

        public MappingDoubleSeq(int length, IntToDoubleFunction getter) {
            super(length);
            this.getter = getter;
        }

        @Override
        public double get(int idx) {
            return this.getter.applyAsDouble(idx);
        }

        @Override
        @NonNull
        public DoubleSeqCursor cursor() {
            return new InternalDoubleSeqCursor.DefaultDoubleSeqCursor<MappingDoubleSeq>(this);
        }

        public String toString() {
            return DoubleSeq.format(this);
        }
    }

    public static class SubDoubleSeq
    extends InternalBaseSeq.SubBaseSeq
    implements DoubleSeq {
        protected final double[] values;

        public SubDoubleSeq(double[] data, int begin, int length) {
            super(begin, length);
            this.values = data;
        }

        @Override
        @NonNull
        public DoubleSeqCursor cursor() {
            return new InternalDoubleSeqCursor.SubDoubleSeqCursor(this.values, this.begin);
        }

        @Override
        public double get(int idx) {
            return this.values[this.begin + idx];
        }

        @Override
        public double @NonNull [] toArray() {
            double[] ndata = new double[this.length];
            System.arraycopy(this.values, this.begin, ndata, 0, this.length);
            return ndata;
        }

        public String toString() {
            return DoubleSeq.format(this);
        }
    }

    public static class MultiDoubleSeq
    extends InternalBaseSeq.MultiBaseSeq
    implements DoubleSeq {
        @NonNull
        protected final double[] values;

        @Override
        public int length() {
            return this.values.length;
        }

        @Override
        public double get(int index) throws IndexOutOfBoundsException {
            return this.values[index];
        }

        @Override
        public double @NonNull [] toArray() {
            return (double[])this.values.clone();
        }

        @Override
        public void copyTo(double @NonNull [] buffer, int offset) {
            if (buffer == null) {
                throw new NullPointerException("buffer is marked non-null but is null");
            }
            System.arraycopy(this.values, 0, buffer, offset, this.values.length);
        }

        @Override
        @NonNull
        public DoubleSeqCursor cursor() {
            return new InternalDoubleSeqCursor.MultiDoubleSeqCursor(this.values);
        }

        public String toString() {
            return DoubleSeq.format(this);
        }

        @Generated
        public MultiDoubleSeq(@NonNull double[] values) {
            if (values == null) {
                throw new NullPointerException("values is marked non-null but is null");
            }
            this.values = values;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MultiDoubleSeq)) {
                return false;
            }
            MultiDoubleSeq other = (MultiDoubleSeq)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return Arrays.equals(this.values, other.values);
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof MultiDoubleSeq;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Arrays.hashCode(this.values);
            return result;
        }
    }
}

