/*
 * Decompiled with CFR 0.152.
 */
package jdplus.sa.base.r;

import java.util.LinkedHashMap;
import java.util.Map;
import jdplus.toolkit.base.api.arima.SarimaOrders;
import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.data.Doubles;
import jdplus.toolkit.base.api.information.GenericExplorable;
import jdplus.toolkit.base.api.information.InformationMapping;
import jdplus.toolkit.base.api.timeseries.TimeSeriesDomain;
import jdplus.toolkit.base.api.timeseries.TsData;
import jdplus.toolkit.base.api.timeseries.TsDomain;
import jdplus.toolkit.base.api.timeseries.TsPeriod;
import jdplus.toolkit.base.api.timeseries.TsUnit;
import jdplus.toolkit.base.api.timeseries.calendars.DayClustering;
import jdplus.toolkit.base.api.timeseries.calendars.GenericTradingDays;
import jdplus.toolkit.base.api.timeseries.regression.GenericTradingDaysVariable;
import jdplus.toolkit.base.api.timeseries.regression.ITsVariable;
import jdplus.toolkit.base.core.arima.IArimaModel;
import jdplus.toolkit.base.core.data.DataBlock;
import jdplus.toolkit.base.core.math.functions.IParametricMapping;
import jdplus.toolkit.base.core.math.functions.ParamValidation;
import jdplus.toolkit.base.core.math.functions.levmar.LevenbergMarquardtMinimizer;
import jdplus.toolkit.base.core.math.functions.ssq.ISsqFunctionPoint;
import jdplus.toolkit.base.core.math.matrices.FastMatrix;
import jdplus.toolkit.base.core.math.matrices.QuadraticForm;
import jdplus.toolkit.base.core.math.matrices.SymmetricMatrix;
import jdplus.toolkit.base.core.modelling.regression.Regression;
import jdplus.toolkit.base.core.sarima.SarimaModel;
import jdplus.toolkit.base.core.sarima.estimation.SarimaMapping;
import jdplus.toolkit.base.core.ssf.ISsfLoading;
import jdplus.toolkit.base.core.ssf.StateComponent;
import jdplus.toolkit.base.core.ssf.arima.SsfArima;
import jdplus.toolkit.base.core.ssf.basic.RegSsf;
import jdplus.toolkit.base.core.ssf.dk.DkToolkit;
import jdplus.toolkit.base.core.ssf.dk.SsfFunction;
import jdplus.toolkit.base.core.ssf.dk.SsfFunctionPoint;
import jdplus.toolkit.base.core.ssf.univariate.DefaultSmoothingResults;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.ssf.univariate.Ssf;
import jdplus.toolkit.base.core.ssf.univariate.SsfData;
import jdplus.toolkit.base.core.stats.likelihood.DiffuseLikelihoodStatistics;
import lombok.Generated;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public final class TimeVaryingRegression {
    public static Results regarima(TsData s, String td, String svar, double aicdiff) {
        int freq = s.getTsUnit().ratioOf(TsUnit.P1Y);
        SarimaOrders spec = SarimaOrders.airline((int)freq);
        DayClustering dc = TimeVaryingRegression.days(td);
        FastMatrix mtd = TimeVaryingRegression.generate(s.getDomain(), dc);
        FastMatrix nvar = TimeVaryingRegression.generateVar(dc, svar);
        SsfData data = new SsfData(s.getValues());
        LevenbergMarquardtMinimizer min = LevenbergMarquardtMinimizer.builder().functionPrecision(1.0E-9).build();
        TDvarMapping mapping0 = new TDvarMapping(mtd, true);
        SsfFunction<Airline, ISsf> fn0 = TimeVaryingRegression.buildFunction(data, spec, mapping0, mtd, nvar);
        min.minimize((ISsqFunctionPoint)fn0.evaluate(mapping0.getDefaultParameters()));
        SsfFunctionPoint rfn0 = (SsfFunctionPoint)min.getResult();
        TDvarMapping mapping = new TDvarMapping(mtd, false);
        SsfFunction<Airline, ISsf> fn = TimeVaryingRegression.buildFunction(data, spec, mapping, mtd, nvar);
        Airline air0 = (Airline)rfn0.getCore();
        air0.setRegVariance(0.001);
        min.minimize((ISsqFunctionPoint)fn.ssqEvaluate(mapping.parametersOf(air0)));
        SsfFunctionPoint rfn = (SsfFunctionPoint)min.getResult();
        double aic0 = rfn0.getLikelihood().AIC(2);
        double aic = rfn.getLikelihood().AIC(3);
        ISsf ssf = aic + aicdiff < aic0 ? rfn.getSsf() : rfn0.getSsf();
        DefaultSmoothingResults fs = DkToolkit.sqrtSmooth((ISsf)ssf, (ISsfData)data, (boolean)true, (boolean)true);
        FastMatrix c = FastMatrix.make((int)mtd.getRowsCount(), (int)(mtd.getColumnsCount() + 1));
        FastMatrix ec = FastMatrix.make((int)mtd.getRowsCount(), (int)(mtd.getColumnsCount() + 1));
        int del = freq + 2;
        double nwe = dc.getGroupCount(0);
        double[] z = new double[c.getColumnsCount() - 1];
        for (int i = 0; i < z.length; ++i) {
            c.column(i).copy(fs.getComponent(del + i));
            ec.column(i).copy(fs.getComponentVariance(del + i));
            z[i] = (double)dc.getGroupCount(i + 1) / nwe;
            c.column(z.length).addAY(-z[i], c.column(i));
        }
        DataBlock Z = DataBlock.of((double[])z);
        for (int i = 0; i < c.getRowsCount(); ++i) {
            FastMatrix var = fs.P(i).dropTopLeft(del, del);
            ec.set(i, z.length, QuadraticForm.apply((FastMatrix)var, (DataBlock)Z));
        }
        ec.apply(x -> x <= 0.0 ? 0.0 : Math.sqrt(x));
        Airline air = (Airline)rfn.getCore();
        SarimaModel arima0 = SarimaModel.builder((SarimaOrders)spec).theta(new double[]{air0.theta}).btheta(new double[]{air0.btheta}).build();
        SarimaModel arima = SarimaModel.builder((SarimaOrders)spec).theta(new double[]{air.theta}).btheta(new double[]{air.btheta}).build();
        return Results.builder().domain(s.getDomain()).arima0(arima0).arima(arima).ll0(rfn0.getLikelihood().stats(0.0, 2)).ll(rfn.getLikelihood().stats(0.0, 3)).nvar(air.regVariance).variables(mtd).coefficients(c).coefficientsStde(ec).build();
    }

    private static SsfFunction<Airline, ISsf> buildFunction(SsfData data, SarimaOrders spec, TDvarMapping mapping, FastMatrix mtd, FastMatrix nvar) {
        return SsfFunction.builder((ISsfData)data, (IParametricMapping)mapping, params -> {
            SarimaModel arima = SarimaModel.builder((SarimaOrders)spec).theta(new double[]{params.getTheta()}).btheta(new double[]{params.getBtheta()}).build();
            Ssf ssf = Ssf.of((StateComponent)SsfArima.stateComponent((IArimaModel)arima), (ISsfLoading)SsfArima.defaultLoading());
            double nv = params.getRegVariance();
            FastMatrix v = nvar.deepClone();
            v.mul(nv);
            return RegSsf.timeVaryingSsf((ISsf)ssf, (FastMatrix)mtd, (FastMatrix)v);
        }).build();
    }

    private static DayClustering days(String td) {
        return switch (td) {
            case "TD2" -> DayClustering.TD2;
            case "TD3" -> DayClustering.TD3;
            case "TD3c" -> DayClustering.TD3c;
            case "TD4" -> DayClustering.TD4;
            default -> DayClustering.TD7;
        };
    }

    public static FastMatrix generate(TsDomain domain, DayClustering dc) {
        GenericTradingDays gtd = GenericTradingDays.contrasts((DayClustering)dc);
        return Regression.matrix((TimeSeriesDomain)domain, (ITsVariable[])new ITsVariable[]{new GenericTradingDaysVariable(gtd)});
    }

    public static FastMatrix generateVar(DayClustering dc, String var) {
        int groupsCount = dc.getGroupsCount();
        FastMatrix full = FastMatrix.square((int)7);
        if (!var.equalsIgnoreCase("Contrasts")) {
            full.set(-0.14285714285714285);
        }
        full.diagonal().add(1.0);
        FastMatrix Q = FastMatrix.make((int)(groupsCount - 1), (int)7);
        int[] gdef = dc.getGroupsDefinition();
        for (int i = 1; i < groupsCount; ++i) {
            for (int j = 0; j < 7; ++j) {
                if (gdef[j] != i) continue;
                Q.set(i - 1, j, 1.0);
            }
        }
        return SymmetricMatrix.XSXt((FastMatrix)full, (FastMatrix)Q);
    }

    @Generated
    private TimeVaryingRegression() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class TDvarMapping
    implements IParametricMapping<Airline> {
        private final FastMatrix td;
        private final boolean fixed;
        private static final SarimaMapping airlineMapping;

        TDvarMapping(FastMatrix td, boolean fixed) {
            this.td = td;
            this.fixed = fixed;
        }

        public FastMatrix getTd() {
            return this.td;
        }

        public Airline map(DoubleSeq p) {
            Airline airline = new Airline();
            airline.setTd(this.td);
            airline.setTheta(p.get(0));
            airline.setBtheta(p.get(1));
            if (this.fixed) {
                airline.setRegVariance(0.0);
            } else {
                airline.setRegVariance(p.get(2));
            }
            return airline;
        }

        public DoubleSeq parametersOf(Airline t) {
            double[] p = new double[this.fixed ? 2 : 3];
            p[0] = t.getTheta();
            p[1] = t.getBtheta();
            if (!this.fixed) {
                p[2] = t.getRegVariance();
            }
            return DoubleSeq.of((double[])p);
        }

        public boolean checkBoundaries(DoubleSeq inparams) {
            if (this.fixed) {
                return airlineMapping.checkBoundaries(inparams.extract(0, 2));
            }
            return inparams.get(2) >= 0.0 && airlineMapping.checkBoundaries(inparams.extract(0, 2));
        }

        public double epsilon(DoubleSeq inparams, int idx) {
            if (idx < 2) {
                return airlineMapping.epsilon(inparams, idx);
            }
            return inparams.get(2) * 0.001;
        }

        public int getDim() {
            return this.fixed ? 2 : 3;
        }

        public double lbound(int idx) {
            if (idx < 2) {
                return airlineMapping.lbound(idx);
            }
            return 0.0;
        }

        public double ubound(int idx) {
            if (idx < 2) {
                return airlineMapping.ubound(idx);
            }
            return 10.0;
        }

        public ParamValidation validate(DataBlock ioparams) {
            ParamValidation pv = ParamValidation.Valid;
            if (!this.fixed && ioparams.get(2) < 0.0) {
                pv = ParamValidation.Changed;
                ioparams.set(2, Math.min(10.0, -ioparams.get(2)));
            }
            if (!this.fixed && ioparams.get(2) > 10.0) {
                pv = ParamValidation.Changed;
                ioparams.set(2, 10.0);
            }
            ParamValidation pv2 = airlineMapping.validate(ioparams.extract(0, 2));
            if (pv == ParamValidation.Valid && pv2 == ParamValidation.Valid) {
                return ParamValidation.Valid;
            }
            if (pv == ParamValidation.Invalid || pv2 == ParamValidation.Invalid) {
                return ParamValidation.Invalid;
            }
            return ParamValidation.Changed;
        }

        public String getDescription(int idx) {
            if (idx < 2) {
                return airlineMapping.getDescription(idx);
            }
            return "noise stdev";
        }

        public DoubleSeq getDefaultParameters() {
            return this.fixed ? Doubles.of((double[])new double[]{-0.6, -0.6}) : Doubles.of((double[])new double[]{-0.6, -0.6, 0.001});
        }

        static {
            SarimaOrders spec = SarimaOrders.airline((int)12);
            airlineMapping = SarimaMapping.of((SarimaOrders)spec);
        }
    }

    static class Airline {
        FastMatrix td;
        double regVariance;
        double theta;
        double btheta;

        @Generated
        public Airline() {
        }

        @Generated
        public FastMatrix getTd() {
            return this.td;
        }

        @Generated
        public double getRegVariance() {
            return this.regVariance;
        }

        @Generated
        public double getTheta() {
            return this.theta;
        }

        @Generated
        public double getBtheta() {
            return this.btheta;
        }

        @Generated
        public void setTd(FastMatrix td) {
            this.td = td;
        }

        @Generated
        public void setRegVariance(double regVariance) {
            this.regVariance = regVariance;
        }

        @Generated
        public void setTheta(double theta) {
            this.theta = theta;
        }

        @Generated
        public void setBtheta(double btheta) {
            this.btheta = btheta;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Airline)) {
                return false;
            }
            Airline other = (Airline)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Double.compare(this.getRegVariance(), other.getRegVariance()) != 0) {
                return false;
            }
            if (Double.compare(this.getTheta(), other.getTheta()) != 0) {
                return false;
            }
            if (Double.compare(this.getBtheta(), other.getBtheta()) != 0) {
                return false;
            }
            FastMatrix this$td = this.getTd();
            FastMatrix other$td = other.getTd();
            return !(this$td == null ? other$td != null : !this$td.equals(other$td));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof Airline;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $regVariance = Double.doubleToLongBits(this.getRegVariance());
            result = result * 59 + (int)($regVariance >>> 32 ^ $regVariance);
            long $theta = Double.doubleToLongBits(this.getTheta());
            result = result * 59 + (int)($theta >>> 32 ^ $theta);
            long $btheta = Double.doubleToLongBits(this.getBtheta());
            result = result * 59 + (int)($btheta >>> 32 ^ $btheta);
            FastMatrix $td = this.getTd();
            result = result * 59 + ($td == null ? 43 : $td.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "TimeVaryingRegression.Airline(td=" + String.valueOf(this.getTd()) + ", regVariance=" + this.getRegVariance() + ", theta=" + this.getTheta() + ", btheta=" + this.getBtheta() + ")";
        }
    }

    public static final class Results
    implements GenericExplorable {
        private final TsDomain domain;
        private final FastMatrix variables;
        private final FastMatrix coefficients;
        private final FastMatrix coefficientsStde;
        private final SarimaModel arima0;
        private final SarimaModel arima;
        private final DiffuseLikelihoodStatistics ll0;
        private final DiffuseLikelihoodStatistics ll;
        private final double nvar;
        private static final String ARIMA0 = "arima0";
        private static final String LL0 = "likelihood0";
        private static final String ARIMA = "arima";
        private static final String LL = "likelihood";
        private static final String STDCOEFF = "coefficients.stde";
        private static final String COEFF = "coefficients.value";
        private static final String TD = "td";
        private static final String TDEFFECT = "tdeffect";
        private static final InformationMapping<Results> MAPPING = new InformationMapping<Results>(){

            public Class getSourceClass() {
                return Results.class;
            }
        };

        public boolean contains(String id) {
            return MAPPING.contains(id);
        }

        public Map<String, Class> getDictionary() {
            LinkedHashMap<String, Class> dic = new LinkedHashMap<String, Class>();
            MAPPING.fillDictionary(null, dic, true);
            return dic;
        }

        public <T> T getData(String id, Class<T> tclass) {
            return (T)MAPPING.getData((Object)this, id, tclass);
        }

        public static final InformationMapping<Results> getMapping() {
            return MAPPING;
        }

        @Generated
        Results(TsDomain domain, FastMatrix variables, FastMatrix coefficients, FastMatrix coefficientsStde, SarimaModel arima0, SarimaModel arima, DiffuseLikelihoodStatistics ll0, DiffuseLikelihoodStatistics ll, double nvar) {
            this.domain = domain;
            this.variables = variables;
            this.coefficients = coefficients;
            this.coefficientsStde = coefficientsStde;
            this.arima0 = arima0;
            this.arima = arima;
            this.ll0 = ll0;
            this.ll = ll;
            this.nvar = nvar;
        }

        @Generated
        public static @NonNull Builder builder() {
            return new Builder();
        }

        @Generated
        public TsDomain getDomain() {
            return this.domain;
        }

        @Generated
        public FastMatrix getVariables() {
            return this.variables;
        }

        @Generated
        public FastMatrix getCoefficients() {
            return this.coefficients;
        }

        @Generated
        public FastMatrix getCoefficientsStde() {
            return this.coefficientsStde;
        }

        @Generated
        public SarimaModel getArima0() {
            return this.arima0;
        }

        @Generated
        public SarimaModel getArima() {
            return this.arima;
        }

        @Generated
        public DiffuseLikelihoodStatistics getLl0() {
            return this.ll0;
        }

        @Generated
        public DiffuseLikelihoodStatistics getLl() {
            return this.ll;
        }

        @Generated
        public double getNvar() {
            return this.nvar;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Results)) {
                return false;
            }
            Results other = (Results)o;
            if (Double.compare(this.getNvar(), other.getNvar()) != 0) {
                return false;
            }
            TsDomain this$domain = this.getDomain();
            TsDomain other$domain = other.getDomain();
            if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
                return false;
            }
            FastMatrix this$variables = this.getVariables();
            FastMatrix other$variables = other.getVariables();
            if (this$variables == null ? other$variables != null : !this$variables.equals(other$variables)) {
                return false;
            }
            FastMatrix this$coefficients = this.getCoefficients();
            FastMatrix other$coefficients = other.getCoefficients();
            if (this$coefficients == null ? other$coefficients != null : !this$coefficients.equals(other$coefficients)) {
                return false;
            }
            FastMatrix this$coefficientsStde = this.getCoefficientsStde();
            FastMatrix other$coefficientsStde = other.getCoefficientsStde();
            if (this$coefficientsStde == null ? other$coefficientsStde != null : !this$coefficientsStde.equals(other$coefficientsStde)) {
                return false;
            }
            SarimaModel this$arima0 = this.getArima0();
            SarimaModel other$arima0 = other.getArima0();
            if (this$arima0 == null ? other$arima0 != null : !this$arima0.equals(other$arima0)) {
                return false;
            }
            SarimaModel this$arima = this.getArima();
            SarimaModel other$arima = other.getArima();
            if (this$arima == null ? other$arima != null : !this$arima.equals(other$arima)) {
                return false;
            }
            DiffuseLikelihoodStatistics this$ll0 = this.getLl0();
            DiffuseLikelihoodStatistics other$ll0 = other.getLl0();
            if (this$ll0 == null ? other$ll0 != null : !this$ll0.equals(other$ll0)) {
                return false;
            }
            DiffuseLikelihoodStatistics this$ll = this.getLl();
            DiffuseLikelihoodStatistics other$ll = other.getLl();
            return !(this$ll == null ? other$ll != null : !this$ll.equals(other$ll));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $nvar = Double.doubleToLongBits(this.getNvar());
            result = result * 59 + (int)($nvar >>> 32 ^ $nvar);
            TsDomain $domain = this.getDomain();
            result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
            FastMatrix $variables = this.getVariables();
            result = result * 59 + ($variables == null ? 43 : $variables.hashCode());
            FastMatrix $coefficients = this.getCoefficients();
            result = result * 59 + ($coefficients == null ? 43 : $coefficients.hashCode());
            FastMatrix $coefficientsStde = this.getCoefficientsStde();
            result = result * 59 + ($coefficientsStde == null ? 43 : $coefficientsStde.hashCode());
            SarimaModel $arima0 = this.getArima0();
            result = result * 59 + ($arima0 == null ? 43 : $arima0.hashCode());
            SarimaModel $arima = this.getArima();
            result = result * 59 + ($arima == null ? 43 : $arima.hashCode());
            DiffuseLikelihoodStatistics $ll0 = this.getLl0();
            result = result * 59 + ($ll0 == null ? 43 : $ll0.hashCode());
            DiffuseLikelihoodStatistics $ll = this.getLl();
            result = result * 59 + ($ll == null ? 43 : $ll.hashCode());
            return result;
        }

        @Generated
        public @NonNull String toString() {
            return "TimeVaryingRegression.Results(domain=" + String.valueOf(this.getDomain()) + ", variables=" + String.valueOf(this.getVariables()) + ", coefficients=" + String.valueOf(this.getCoefficients()) + ", coefficientsStde=" + String.valueOf(this.getCoefficientsStde()) + ", arima0=" + String.valueOf(this.getArima0()) + ", arima=" + String.valueOf(this.getArima()) + ", ll0=" + String.valueOf(this.getLl0()) + ", ll=" + String.valueOf(this.getLl()) + ", nvar=" + this.getNvar() + ")";
        }

        static {
            MAPPING.delegate(LL0, DiffuseLikelihoodStatistics.class, r -> r.getLl0());
            MAPPING.delegate(LL, DiffuseLikelihoodStatistics.class, r -> r.getLl());
            MAPPING.set("aic0", Double.class, r -> r.getLl0().aic());
            MAPPING.set("aic", Double.class, r -> r.getLl().aic());
            MAPPING.set("tdvar", Double.class, r -> r.getNvar());
            MAPPING.set(COEFF, FastMatrix.class, r -> r.getCoefficients());
            MAPPING.set(STDCOEFF, FastMatrix.class, r -> r.getCoefficientsStde());
            MAPPING.set(TD, FastMatrix.class, r -> r.getVariables());
            MAPPING.set(TDEFFECT, TsData.class, r -> {
                DataBlock tmp = DataBlock.make((int)r.getDomain().length());
                DataBlock prod = DataBlock.make((int)r.getDomain().length());
                for (int i = 0; i < r.variables.getColumnsCount(); ++i) {
                    prod.set(r.getCoefficients().column(i), r.getVariables().column(i), (a, b) -> a * b);
                    tmp.add(prod);
                }
                return TsData.of((TsPeriod)r.getDomain().getStartPeriod(), (DoubleSeq)tmp);
            });
        }

        @Generated
        public static class Builder {
            @Generated
            private TsDomain domain;
            @Generated
            private FastMatrix variables;
            @Generated
            private FastMatrix coefficients;
            @Generated
            private FastMatrix coefficientsStde;
            @Generated
            private SarimaModel arima0;
            @Generated
            private SarimaModel arima;
            @Generated
            private DiffuseLikelihoodStatistics ll0;
            @Generated
            private DiffuseLikelihoodStatistics ll;
            @Generated
            private double nvar;

            @Generated
            Builder() {
            }

            @Generated
            public @NonNull Builder domain(TsDomain domain) {
                this.domain = domain;
                return this;
            }

            @Generated
            public @NonNull Builder variables(FastMatrix variables) {
                this.variables = variables;
                return this;
            }

            @Generated
            public @NonNull Builder coefficients(FastMatrix coefficients) {
                this.coefficients = coefficients;
                return this;
            }

            @Generated
            public @NonNull Builder coefficientsStde(FastMatrix coefficientsStde) {
                this.coefficientsStde = coefficientsStde;
                return this;
            }

            @Generated
            public @NonNull Builder arima0(SarimaModel arima0) {
                this.arima0 = arima0;
                return this;
            }

            @Generated
            public @NonNull Builder arima(SarimaModel arima) {
                this.arima = arima;
                return this;
            }

            @Generated
            public @NonNull Builder ll0(DiffuseLikelihoodStatistics ll0) {
                this.ll0 = ll0;
                return this;
            }

            @Generated
            public @NonNull Builder ll(DiffuseLikelihoodStatistics ll) {
                this.ll = ll;
                return this;
            }

            @Generated
            public @NonNull Builder nvar(double nvar) {
                this.nvar = nvar;
                return this;
            }

            @Generated
            public @NonNull Results build() {
                return new Results(this.domain, this.variables, this.coefficients, this.coefficientsStde, this.arima0, this.arima, this.ll0, this.ll, this.nvar);
            }

            @Generated
            public @NonNull String toString() {
                return "TimeVaryingRegression.Results.Builder(domain=" + String.valueOf(this.domain) + ", variables=" + String.valueOf(this.variables) + ", coefficients=" + String.valueOf(this.coefficients) + ", coefficientsStde=" + String.valueOf(this.coefficientsStde) + ", arima0=" + String.valueOf(this.arima0) + ", arima=" + String.valueOf(this.arima) + ", ll0=" + String.valueOf(this.ll0) + ", ll=" + String.valueOf(this.ll) + ", nvar=" + this.nvar + ")";
            }
        }
    }
}

