% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxp_write_dag.R
\name{rxp_write_dag}
\alias{rxp_write_dag}
\title{Generate a DAG from a list of derivations}
\usage{
rxp_write_dag(rxp_list, output_file = "_rixpress/dag.json")
}
\arguments{
\item{rxp_list}{A list of derivations.}

\item{output_file}{Path to the output JSON file.
Defaults to "_rixpress/dag.json".}
}
\value{
Nothing, writes a JSON file representing the DAG.
}
\description{
Creates a JSON representation of a directed acyclic graph (DAG)
based on dependencies between derivations. Is automatically called
by \code{rxp_populate()}.
}
\examples{
\dontrun{
  rxp_write_dag(rxp_list)
}
}
\seealso{
Other ci utilities: 
\code{\link{rxp_dag_for_ci}()},
\code{\link{rxp_ga}()}
}
\concept{ci utilities}
