% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.gComp.R
\name{print.gComp}
\alias{print.gComp}
\title{Print estimates of difference and ratio effects obtained in the bootstrap
computations of the g-computation}
\usage{
\method{print}{gComp}(x, ...)
}
\arguments{
\item{x}{(Required) An object of class \code{gComp} as produced by \code{gComp()}.}

\item{...}{(Optional) Further arguments passed to or from other methods.}
}
\value{
Returns the formula and resulting point estimate and 95\% 
confidence intervals of the difference and ratio.
}
\description{
Print results from bootstrap computations of the g-computation
}
\examples{
## Obtain the risk difference and risk ratio for cardiovascular disease or 
## death between patients with and without diabetes, while controlling for
## age, sex, BMI, whether the individual is currently a smoker, and 
## if they have a history of hypertension.
data(cvdd)
set.seed(4832)
diabetes.result <- gComp(cvdd, 
   formula = "cvd_dth ~ DIABETES + AGE + SEX + BMI + CURSMOKE + PREVHYP",
   outcome.type = "binary", R = 20)
print(diabetes.result)


}
\keyword{print.gComp}
