% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_github_data.R
\name{count_commits_last_months}
\alias{count_commits_last_months}
\title{Count Commits in the Last Months}
\usage{
count_commits_last_months(df, months = 1, today = Sys.Date())
}
\arguments{
\item{df}{A data frame with `week_start` (Date) and `n_commits` (int) columns.}

\item{months}{Integer. Number of months to look back (default is 1).}

\item{today}{today's date.default is Sys.Date()}
}
\value{
Integer. Total number of commits in the time window.
}
\description{
Counts the total number of commits from the last `months` months using a 
data frame with weekly commit data (column `week_start`).
}
\examples{
\dontrun{
df <- get_commits_since("tidyverse", "ggplot2", years = 1)
count_commits_last_months(df, months = 3)
}
}
