% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theo_mu_sig.R
\name{theo_mu_sig}
\alias{theo_mu_sig}
\title{get analytic expressions of expectations, variances and covariances}
\usage{
theo_mu_sig(E, n1, n2, weights)
}
\arguments{
\item{E}{an edge matrix representing a similarity graph. Each row represents an edge and records the indices of two ends of an edge in two columns. The indices of observations in sample 1 are from 1 to n1 and indices of observations in sample 2 are from 1+n1 to n1+n2.}

\item{n1}{number of observations in sample 1}

\item{n2}{number of observations in sample 2}

\item{weights}{weights assigned to each edges}
}
\value{
\item{mu}{the expectation of the between-sample edge-count.}
\item{mu1}{the expectation of the within-sample edge-count for sample 1.}
\item{mu2}{the expectation of the within-sample edge-count for sample 2.}
\item{sig}{the variance of the between-sample edge-count.}
\item{sig11}{the variance of the within-sample edge-count for sample 1.}
\item{sig22}{the variance of the within-sample edge-count for sample 2.}
\item{sig12}{the covariance of the within-sample edge-counts.}
}
\description{
get analytic expressions of expectations, variances and covariances
}
\keyword{internal}
