/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.nary.alldifferentprec;

import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Comparator;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.nary.alldifferentprec.FilterAllDiffPrec;
import org.chocosolver.solver.constraints.nary.alldifferentprec.IntUnionFind;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.util.objects.graphs.DirectedGraph;

public class AllDiffPrec
extends FilterAllDiffPrec {
    private IntUnionFind unionFind;
    private final IntUnionFind unionFindLB;
    private final IntUnionFind unionFindUB;
    private final ArrayList<Integer> list;
    private final int[] lb;
    private final int[] ub;
    private final int[] ubFilt;
    private final Comparator<Integer> comparator = new Comparator<Integer>(){

        @Override
        public int compare(Integer o1, Integer o2) {
            if (AllDiffPrec.this.ub[o1] == AllDiffPrec.this.ub[o2]) {
                if (AllDiffPrec.this.lb[o1] == AllDiffPrec.this.lb[o2]) {
                    return o1 - o2;
                }
                return AllDiffPrec.this.lb[o1] - AllDiffPrec.this.lb[o2];
            }
            return AllDiffPrec.this.ub[o1] - AllDiffPrec.this.ub[o2];
        }
    };

    public AllDiffPrec(IntVar[] variables, boolean[][] precedence) {
        super(variables, precedence);
        int i;
        TIntHashSet set = new TIntHashSet();
        TIntHashSet set2 = new TIntHashSet();
        for (i = 0; i < variables.length; ++i) {
            for (int v = variables[i].getLB(); v <= variables[i].getUB(); ++v) {
                set.add(v);
                set2.add(-v);
            }
        }
        this.unionFindUB = new IntUnionFind(set.toArray());
        this.unionFindLB = new IntUnionFind(set2.toArray());
        this.list = new ArrayList();
        for (i = 0; i < variables.length; ++i) {
            this.list.add(i);
        }
        this.lb = new int[variables.length];
        this.ub = new int[variables.length];
        this.ubFilt = new int[variables.length];
    }

    @Override
    public PropagatorPriority getPriority() {
        return PropagatorPriority.QUADRATIC;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        return IntEventType.boundAndInst();
    }

    private boolean isBefore(boolean filterUb, int i, int j) {
        if (filterUb) {
            return this.precedence[i][j];
        }
        return this.precedence[j][i];
    }

    private void writeLbUb(boolean filterUb) {
        for (int i = 0; i < this.variables.length; ++i) {
            if (filterUb) {
                this.lb[i] = this.variables[i].getLB();
                this.ub[i] = this.variables[i].getUB();
                continue;
            }
            this.lb[i] = -this.variables[i].getUB();
            this.ub[i] = -this.variables[i].getLB();
        }
    }

    private void filterLbUb(boolean filterUb, ICause aCause) throws ContradictionException {
        for (int i = 0; i < this.variables.length; ++i) {
            if (filterUb) {
                this.variables[i].updateUpperBound(this.ubFilt[i], aCause);
                continue;
            }
            this.variables[i].updateLowerBound(-this.ubFilt[i], aCause);
        }
    }

    private boolean filter(boolean filterUb) {
        boolean hasFiltered = false;
        this.list.sort(this.comparator);
        for (int i = 0; i < this.variables.length; ++i) {
            this.unionFind.init();
            this.ubFilt[i] = this.ub[i];
            int b = this.ub[this.list.get(0)] + 1;
            boolean encountered = false;
            for (int k = 0; k < this.list.size(); ++k) {
                int idxSet;
                int j = this.list.get(k);
                if (j == i) {
                    encountered = true;
                }
                if (k > 0) {
                    for (int l = 0; l < this.ub[this.list.get(k)] - this.ub[this.list.get(k - 1)]; ++l) {
                        idxSet = this.unionFind.find(b);
                        if (idxSet == -1) {
                            ++b;
                            continue;
                        }
                        b = this.unionFind.getMax(idxSet) + 1;
                    }
                }
                if (j == i) continue;
                int v = -1;
                if (!this.isBefore(filterUb, i, j)) {
                    idxSet = this.unionFind.find(this.lb[j]);
                    v = this.unionFind.getMin(idxSet);
                    if (this.unionFind.find(this.unionFind.getMax(idxSet) + 1) >= 0) {
                        this.unionFind.union(v, this.unionFind.getMax(idxSet) + 1);
                    }
                }
                if (k > 0 && (this.isBefore(filterUb, i, j) || v > b || this.unionFind.find(v) == this.unionFind.find(b))) {
                    idxSet = this.unionFind.find(b - 1);
                    b = idxSet == -1 ? --b : this.unionFind.getMin(idxSet);
                }
                if (!encountered || this.ubFilt[i] <= b - 1) continue;
                hasFiltered = true;
                this.ubFilt[i] = b - 1;
            }
        }
        return hasFiltered;
    }

    private boolean propagateBounds(boolean filterUb, ICause aCause) throws ContradictionException {
        this.writeLbUb(filterUb);
        this.unionFind = filterUb ? this.unionFindUB : this.unionFindLB;
        boolean hasFiltered = this.filter(filterUb);
        this.filterLbUb(filterUb, aCause);
        return hasFiltered;
    }

    @Override
    public boolean propagate(DirectedGraph precedenceGraph, int[] topologicalTraversal, ICause aCause) throws ContradictionException {
        return this.propagateBounds(true, aCause) || this.propagateBounds(false, aCause);
    }
}

