% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelled_spss_survey_coercion.R
\name{labelled_spss_survey_coercion}
\alias{labelled_spss_survey_coercion}
\alias{as_numeric}
\alias{as_character}
\alias{as_factor}
\title{Coercion methods for labelled survey vectors}
\usage{
as_numeric(x)

as_character(x)

as_factor(x, levels = "default", ordered = FALSE)
}
\arguments{
\item{x}{A labelled survey vector created with
[labelled_spss_survey()].}

\item{levels}{Character string indicating how factor levels
should be constructed. Currently retained for compatibility.}

\item{ordered}{Logical; whether the resulting factor should be ordered.
Currently ignored.}
}
\value{
* `as_numeric()` returns a numeric vector with labelled missing
  values converted to `NA`.
* `as_character()` returns a character vector based on the
  factor representation of `x`.
* `as_factor()` returns a factor with levels derived from value
  labels.
}
\description{
Convert labelled SPSS-style survey vectors to common R data types.
These helpers provide consistent coercion behavior for
`"retroharmonize_labelled_spss_survey"` objects while respecting
labelled missing values.
}
\seealso{
[labelled_spss_survey()],
[haven::as_factor()]

Other type conversion functions: 
\code{\link{as_labelled_spss_survey}()}
}
\concept{type conversion functions}
