% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_env.R
\name{extract_env}
\alias{extract_env}
\title{extract_env}
\usage{
extract_env(
  x,
  fs,
  low_pass = 80,
  fs_out = 80,
  win = c(700, 1300),
  mean_centre = FALSE,
  replace_init = FALSE
)
}
\arguments{
\item{x}{a speech signal}

\item{fs}{sampling frequency of signal}

\item{low_pass}{frequency of lowpass filter used for smoothing}

\item{fs_out}{output sampling frequency}

\item{win}{lower and upper frequencies for initial bypass filter. Default is 700Hz-1300Hz as in Tilson & Johnson (2008)}

\item{mean_centre}{if TRUE signal will be scaled between 0 and 1 and then mean centred. Default is FALSE}

\item{replace_init}{if TRUE (default is FALSE) first sample of result will be replaced with second sample to deal with initialisation issue in resampling}
}
\value{
A matrix with time and amplitude
}
\description{
Extract amplitude envelope of filtered speech signal. Adapted from Tilson & Johnson (2008). Procedure:
}
\details{
1. Signal is bypass filtered to extract desired frequency range
2. Absolute signal is then lowpass filtered
3. Signal is downsampled and mean centred if desired
}
\references{
Tilsen, S., & Johnson, K. (2008). Low-frequency Fourier analysis of speech rhythm. The Journal of the Acoustical Society of America, 124(2), EL34–EL39. doi:10.1121/1.2947626
}
\seealso{
fft_spectro
}
