% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_lognormal.R
\name{dist_lognormal}
\alias{dist_lognormal}
\title{Log Normal distribution}
\usage{
dist_lognormal(meanlog = NULL, sdlog = NULL)
}
\arguments{
\item{meanlog}{Scalar mean parameter on the log scale,
or \code{NULL} as a placeholder.}

\item{sdlog}{Scalar standard deviation parameter on the log scale,
or \code{NULL} as a placeholder.}
}
\value{
A \code{LognormalDistribution} object.
}
\description{
See \link[stats:Lognormal]{stats::Lognormal}.
}
\details{
Both parameters can be overridden with
\code{with_params = list(meanlog = ..., sdlog = ...)}.
}
\examples{
mu <- 0
sigma <- 1

d_lnorm <- dist_lognormal(meanlog = mu, sdlog = sigma)
x <- d_lnorm$sample(20)
d_emp <- dist_empirical(x, positive = TRUE)

plot_distributions(
  empirical = d_emp,
  theoretical = d_lnorm,
  estimated = d_lnorm,
  with_params = list(
    estimated = inflate_params(
      fitdistrplus::fitdist(x, distr = "lnorm")$estimate
    )
  ),
  .x = seq(1e-3, 5, length.out = 100)
)

}
\seealso{
Other Distributions: 
\code{\link{Distribution}},
\code{\link{dist_bdegp}()},
\code{\link{dist_beta}()},
\code{\link{dist_binomial}()},
\code{\link{dist_blended}()},
\code{\link{dist_dirac}()},
\code{\link{dist_discrete}()},
\code{\link{dist_empirical}()},
\code{\link{dist_erlangmix}()},
\code{\link{dist_exponential}()},
\code{\link{dist_gamma}()},
\code{\link{dist_genpareto}()},
\code{\link{dist_mixture}()},
\code{\link{dist_negbinomial}()},
\code{\link{dist_normal}()},
\code{\link{dist_pareto}()},
\code{\link{dist_poisson}()},
\code{\link{dist_translate}()},
\code{\link{dist_trunc}()},
\code{\link{dist_uniform}()},
\code{\link{dist_weibull}()}
}
\concept{Distributions}
