% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{install}
\alias{install}
\title{Install the packages provided to this function}
\usage{
install(
  packages = NULL,
  path_to_requirements = NULL,
  quiet = TRUE,
  upgrade = "always"
)
}
\arguments{
\item{packages}{(Optional, String, also as vector)
The actual packages to install.}

\item{path_to_requirements}{(Optional, String) The path (including filename
and type ending) to a text file containing all the packages to install.}

\item{quiet}{If \code{TRUE}, suppress output.}

\item{upgrade}{Should package dependencies be upgraded? One of "default", "ask", "always", or "never". "default"
respects the value of the \code{R_REMOTES_UPGRADE} environment variable if set,
and falls back to "ask" if unset. "ask" prompts the user for which out of
date packages to upgrade. For non-interactive sessions "ask" is equivalent
to "always". \code{TRUE} and \code{FALSE} are also accepted and correspond to
"always" and "never" respectively.}
}
\value{
(Boolean) `TRUE` if all packages are successfully installed,
 `FALSE` otherwise.
}
\description{
Install the packages provided to this function
}
\examples{
\dontrun{
 ## Test it with a string:
 demo_string <- "
 DIZutils
 data.table
 joundso/mainzelliste-connector
 miracum/misc-dizutils@development
 # this_one_will_be_ignored
 "
 requiRements::install(packages = demo_string)

 ## Test it with a vector:
 demo_vec <-
   c(
     "",
     "DIZutils",
     "data.table",
     "joundso/mainzelliste-connector",
     "miracum/misc-dizutils@development",
     "# this_one_will_be_ignored"
   )
 requiRements::install(packages = demo_vec)

 ## Test it with a file:
 demo_path <- "./data-raw/requirements.txt"
 requiRements::install(path_to_requirements = demo_path)

 ## Test it with a string AND a file:
 requiRements::install(packages = demo_string,
                       path_to_requirements = demo_path)

 ## Test it with a vector AND a file:
 requiRements::install(packages = demo_vec,
                       path_to_requirements = demo_path)
}
}
