% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPaperData.R
\docType{data}
\name{KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello15EMSE}
\alias{KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello15EMSE}
\title{KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello15EMSE data}
\format{
`KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello15EMSE`: a data frame with 48
rows and 10 variables:
\describe{
\item{ExperimentID}{<fct>|ExperimentID: A unique identifier for each experiment in the data set.}
\item{ParticipantID}{<fct>|Participant ID: An identifier for each participant, unique for a
specific experiment.}
\item{SequenceGroup}{<fct>|Experimental Sequence Group: A (CL-NOCL,Jedit-Atunes),
B (NOCL-CL,Atunes-Jedit), C(NOCL-CL,Jedit-Atunes), D(CL-NOCL,Atunes-Jedit)}
\item{System}{<fct>|Software systems used in the experiment: Jedit and Atunes}
\item{Treatment}{<fct>|Experimental Treatment: Use of Concept Location plug-in (CL) vs
no Concept Location plug-in (NOCL)}
\item{Period}{<fct>|Time period of the cross-over experiment: 1 or 2}
\item{Correctness}{<int>|Dependent variable: 0, 1, 2, 3, 4. The participants are asked to
indicate a single change method for each of 4 bug reports. A change method is correctly
identified if that method is in the change set of the bug report.}
\item{Time}{<dbl>|Dependent variable: The total time [min] to accomplish concept location tasks,
i.e.,to identify (four) bugs given their reports}
\item{Efficiency}{<dbl>|Dependent variable: The participants’ efficiency in the execution of
concept location tasks. It is computed dividing correctness by time. }
\item{CrossOverID}{<fct>|Crossover category: For 4 group crossover designs, the crossover
category specifies the matching pairs of sequence groups, CO1 and CO2. }
}
}
\usage{
KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello15EMSE
}
\description{
Data illustrate correlations between results from individual participants in cross-over
experiment usb2 conducted by Scanniello et al:
[1] G. Scanniello, A. Marcus, and D. Pascale, 'Link analysis algorithms for static concept
location: an empirical assessment', Empirical Software Engineering, vol. 20, no. 6,
pp. 1666–1720, 2015.
The goal of the experiment is to assess whether a new technique (implemented as an Eclipse
plug-in) for static concept location (proposed by the authors) supports users in identifying the
places in the code where changes are to be made.
}
\details{
If you use this data set please cite:
[1] G. Scanniello, A. Marcus, and D. Pascale, 'Link analysis algorithms for static concept
location: an empirical assessment', Empirical Software Engineering, vol. 20, no. 6,
pp. 1666–1720, 2015.
[2] Barbara Kitchenham, Lech Madeyski, Giuseppe Scanniello and Carmine Gravino, 'The importance
of the Correlation between Results from Individual Participants in Crossover Experiments'
(to be submitted as of 2020).
}
\examples{
KitchenhamEtAl.CorrelationsAmongParticipants.Scanniello15EMSE

}
\keyword{datasets}
