% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valReplacement.R
\name{replaceVals}
\alias{replaceVals}
\title{User-intended wrapper for single-file replacements}
\usage{
replaceVals(dir, ..., save = TRUE)
}
\arguments{
\item{dir}{Quoted character of length = 1 describing the path to the directory containing the data and associated
lookup files, with either forward or double backward slash and no end slash (e.g. \emph{"C:/path/to/directory"}).}

\item{...}{Not used when file names are "data.csv", "lookup.csv". Otherwise, custom names including file extension,
within quotation marks, such as "<data_name>.csv", "<lookup_name>.csv", \strong{entered in this order!}.}

\item{save}{Logical, default TRUE: save results to \emph{dir}. FALSE: display only. See Note below.}
}
\value{
A named list containing updated data and multiple replacement counts. Also, a csv file saved in the
same directory, under the name updated_<data_name>\emph{using}<lookup_name>.csv.
}
\description{
The function sends the prepared data.tables to \link[=sReplace]{sReplace}, receives updated data, displays a
list of updated data and of counts of multiple replacements and saves updated data to disk (see Details).
}
\details{
The workflow:
\subsection{Tasks}{

The function reads the data/lookup pair converting each file to "data.table" class, performs conformance checks
on associated lookup, removes uninvolved data columns and non-standard lookup columns. Upon return from
\link[=sReplace]{sReplace}, re-structures updated result in the original format, saves the updated data to \emph{dir}
and displays a one-run named list containing updated data along with counts of duplicated and/or missing values
replacements requests.
}

\subsection{Messages}{

The function displays messages and comments regarding the internal workflow. It is recommended reading these
messages/comments as first troubleshooting step since they are specific to each file pair and request type.
To suppress messages, wrap the function with \link[base:message]{suppressMessages}.
The vignette contains definitions of terms.
}
}
\section{Note}{
 In examples, please leave argument \emph{save} to FALSE. Otherwise, copy all content of folder "extdata"
found in the installed package root into a directory on your machine. Use the absolute path to this directory as
\emph{dir} argument.
}

\examples{

## Not run: datasets with default names "data.csv", "lookup.csv" located in *dir*

if (interactive()) {
 dir = system.file("extdata", package = "replacer")
 replaceVals(dir, save = FALSE)

  ## no messages (not recommended!)
 suppressMessages(replaceVals(dir, save = FALSE))
 }

}
\seealso{
\link[=bReplace]{bReplace}, \link[=sReplace]{sReplace}
}
\keyword{data}
\keyword{datasets}
\keyword{manip}
\keyword{misc}
