% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Claims-class.R
\docType{methods}
\name{summy}
\alias{summy}
\alias{summy,Claims-method}
\title{Claims: Summary function}
\usage{
summy(object, op = "mean")

\S4method{summy}{Claims}(object, op = "mean")
}
\arguments{
\item{object}{The Claims object to represent.}

\item{op}{Character. The aggregation operation over the simulIds, among:
\itemize{
 \item{\code{mean}: default value.}
 \item{\code{sd}}
 \item{\code{median}}
 \item{\code{min}}
 \item{\code{max}}
}}
}
\value{
The summarized data
}
\description{
\code{summy} summarizes the data contained in the object \code{Claims} (\code{\link{Claims-class}}).
}
\examples{
c <- data.frame(year = unlist(sapply(2000:2017, function(x) rep(x, rpois(1,3)))))
c$amount <- pmax(rnorm(nrow(c), 200000, 100000), 0)
p <- aggregate(amount ~ year, c, sum)
claims <- claims(c, p)
treaty_1 <- xl(ded = 100000, lim = 20000, aad = 5000,
               aal = 200000, prm = 0.01, rns = 1)
claims <- apply_treaty(claims, treaty_1)
summy(claims)

}
