% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_utils.R
\name{check_data_arg}
\alias{check_data_arg}
\title{Check that the model fit uses the data argument to provide data}
\usage{
check_data_arg(fit)
}
\arguments{
\item{fit}{A fitted model object, whose call is to be examined}
}
\value{
No value. Raises an error if no \code{data} argument was used in \code{fit}.
}
\description{
We simulate by passing simulated data arguments to update(). If the original
fit does not use the data argument, and instead refers directly to variables
in the environment, the simulations will not behave as expected. This may
result in the "simulated" fits all using the original data, for instance.
}
\details{
For example, in \code{lm(mtcars$mpg ~ mtcars$drat)}, simulating new data and
providing it in \verb{data =} will not change the data used for fitting.

Detect a missing \code{data} argument and abort. It is still possible to provide
\code{data} but also refer directly to the calling environment, but this is harder
to detect.
}
\keyword{internal}
