% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{rec.pattern.matrix}
\alias{rec.pattern.matrix}
\title{REC Metric 3}
\usage{
rec.pattern.matrix(
  data,
  domainlist = NULL,
  domainnames = NULL,
  labels = NULL,
  na.rm = TRUE
)
}
\arguments{
\item{data}{A data.frame or tibble  (required)}

\item{domainlist}{A list of character vectors or numeric vectors denoting the
columns for each domain (required)}

\item{domainnames}{A character vector supplying updated names to be attached
to output}

\item{labels}{A character vector supplying updated variable names to be
attached to output}

\item{na.rm}{logical (defaults to TRUE)}
}
\value{
A single numerical value
}
\description{
An (Number of Items)x(Number of Domains) matrix such that each row
corresponds to an indicator, and the entry in column i is the average REC
score for that indicator with the other indicators in domain i. This will
allow one in some sense to see if certain indicators seem to have higher REC
scores in a domain other than to the other in which they were assigned
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
  # Use the SCWB data example
  mylist <- list(
    domain_goodrel = c("cwbcloserel", "cwbrespect", "cwbtrust", "cwbmutuality"),
    domain_prolead = c("cwbbeneficence", "cwbintegrity", "cwbcompetence", "cwbvision"),
    domain_healthyprac = c("cwbrelgrowth", "cwbfairness", "cwbsustenance", "cwbachieve"),
    domain_satcomm = c("cwbsatisf", "cwbvalue", "cwbbelonging", "cwbwelcome"),
    domain_strongmiss = c("cwbpurpose", "cwbcontrib", "cwbinterconn", "cwbsynergy")
  )
  rec.pattern.matrix(SCWB, mylist)
}
