% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{rec.coherence}
\alias{rec.coherence}
\title{REC Metric 3}
\usage{
rec.coherence(data, domainlist = NULL, domainnames = NULL, na.rm = TRUE)
}
\arguments{
\item{data}{A data.frame or tibble  (required)}

\item{domainlist}{A list of character vectors or numeric vectors denoting the
columns for each domain (required)}

\item{domainnames}{A character vector supplying updated names to be attached to
output}

\item{na.rm}{logical (defaults to TRUE)}
}
\value{
A single numerical value
}
\description{
The average value of the REC domain coherence taken across domains (which,
when the domains all have the same number of indicators, I believe will also
equal the average within-domain REC vs. the average cross-domain REC); this
gives a measure of the coherence of the partition formed by the various
domains as a whole
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
  # Use the SCWB data example
  mylist <- list(
    domain_goodrel = c("cwbcloserel", "cwbrespect", "cwbtrust", "cwbmutuality"),
    domain_prolead = c("cwbbeneficence", "cwbintegrity", "cwbcompetence", "cwbvision"),
    domain_healthyprac = c("cwbrelgrowth", "cwbfairness", "cwbsustenance", "cwbachieve"),
    domain_satcomm = c("cwbsatisf", "cwbvalue", "cwbbelonging", "cwbwelcome"),
    domain_strongmiss = c("cwbpurpose", "cwbcontrib", "cwbinterconn", "cwbsynergy")
  )
  rec.coherence(SCWB, mylist)
}
