% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretize.R
\name{step_discretize}
\alias{step_discretize}
\title{Discretize Numeric Variables}
\usage{
step_discretize(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  num_breaks = 4,
  min_unique = 10,
  objects = NULL,
  options = list(prefix = "bin"),
  skip = FALSE,
  id = rand_id("discretize")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the sequence of
operations for this recipe.}

\item{...}{One or more selector functions to choose variables for this step.
See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are created.}

\item{trained}{A logical to indicate if the quantities for preprocessing have
been estimated.}

\item{num_breaks}{An integer defining how many cuts to make of the
data.}

\item{min_unique}{An integer defining a sample size line of
dignity for the binning. If (the number of unique
values)\verb{/(cuts+1)} is less than \code{min_unique}, no
discretization takes place.}

\item{objects}{The \code{\link[=discretize]{discretize()}} objects are stored
here once the recipe has be trained by
\code{\link[=prep]{prep()}}.}

\item{options}{A list of options to \code{\link[=discretize]{discretize()}}. A
default is set for the argument \code{x}. Note that using
the options \code{prefix} and \code{labels} when more than one
variable is being transformed might be problematic as all
variables inherit those values.}

\item{skip}{A logical. Should the step be skipped when the recipe is baked by
\code{\link[=bake]{bake()}}? While all operations are baked when \code{\link[=prep]{prep()}} is run, some
operations may not be able to be conducted on new data (e.g. processing the
outcome variable(s)). Care should be taken when using \code{skip = TRUE} as it
may affect the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_discretize()} creates a \emph{specification} of a recipe step that will
convert numeric data into a factor with bins having approximately the same
number of data points (based on a training set).
}
\details{
Note that missing values will be turned into a factor level with the level
\code{prefix_missing}, where \code{prefix} is specified in the \code{options} argument.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms}, \code{value} , and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{value}{numeric, the breaks}
\item{id}{character, id of this step}
}
}

\section{Tuning Parameters}{
This step has 2 tuning parameters:
\itemize{
\item \code{min_unique}: Unique Value Threshold (type: integer, default: 10)
\item \code{num_breaks}: Number of Cut Points (type: integer, default: 4)
}
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(biomass, package = "modeldata")

biomass_tr <- biomass[biomass$dataset == "Training", ]
biomass_te <- biomass[biomass$dataset == "Testing", ]

rec <- recipe(
  HHV ~ carbon + hydrogen + oxygen + nitrogen + sulfur,
  data = biomass_tr
) |>
  step_discretize(carbon, hydrogen)

rec <- prep(rec, biomass_tr)
binned_te <- bake(rec, biomass_te)
table(binned_te$carbon)

tidy(rec, 1)
\dontshow{\}) # examplesIf}
}
\seealso{
Other discretization steps: 
\code{\link{step_cut}()}
}
\concept{discretization steps}
