% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R, R/hydrobudget-quality.R
\name{evaluate_simulation_quality}
\alias{evaluate_simulation_quality}
\alias{evaluate_simulation_quality.default}
\alias{evaluate_simulation_quality.hydrobudget}
\title{Evaluate the quality of the simulation result}
\usage{
evaluate_simulation_quality(obj, water_budget, ...)

\method{evaluate_simulation_quality}{default}(obj, water_budget, ...)

\method{evaluate_simulation_quality}{hydrobudget}(
  obj,
  water_budget,
  rcn_gauging,
  observed_flow,
  alpha_lyne_hollick,
  period = NULL,
  ...
)
}
\arguments{
\item{obj}{The HydroBudget object with calibration parameters and column names mappings.}

\item{water_budget}{The computed water budget. Input can be a data.frame/data.table or a path to a data file.}

\item{...}{Other arguments passed to methods}

\item{rcn_gauging}{The table with the list of RCN cells located in each gauging station watershed. Input can be a data.frame/data.table or a path to a data file.}

\item{observed_flow}{The flow rates in mm/day. Input can be a data.frame/data.table or a path to a data file.}

\item{alpha_lyne_hollick}{The Lyne and Hollick filter. Input can be a data.frame/data.table or a path to a data file.}

\item{period}{The start and end years. If not provided, the start/end years will be extracted from the water budget data.}
}
\value{
The model-specific quality assessment.

The HydroBudget quality assessment.
}
\description{
From a simulation result, evaluate the quality by comparing with observations. The quality
measurement can be used for model calibration (e.g. caRamel package) or sensitivity evaluation
(e.g. sensitivity package).

Evaluates the simulated water budget with the average KGE.
}
\details{
The columns of the water budget data set input are:
\itemize{
\item \strong{year}
\item \strong{month}
\item \strong{vi}
\item \strong{t_mean}
\item \strong{runoff}
\item \strong{pet}
\item \strong{aet}
\item \strong{gwr}
\item \strong{runoff_2}
\item \strong{delta_reservoir}
\item \strong{rcn_id}
}

The columns of the observed flow data set input are:
\itemize{
\item \strong{year}
\item \strong{month}
\item \strong{day}
\item \strong{one column per station} (named by the station ID), the flow rates in mm/day
}

The columns of the RCN gauging stations data set input are:
\itemize{
\item \strong{rcn_id}, the cell ID
\item \strong{station_id}, the station ID
}

The columns of the Lyne and Hollick filter data set input are:
\itemize{
\item \strong{station_id}, the station ID
\item \strong{alpha}
}
}
\examples{
\dontrun{
# Use input example files provided by the package
base_url <- "https://github.com/gwrecharge/rechaRge-book/raw/main/examples/input/"
input_rcn_gauging <- paste0(base_url, "rcn_gauging.csv.gz")
input_observed_flow <- paste0(base_url, "observed_flow.csv.gz")
input_alpha_lyne_hollick <- paste0(base_url, "alpha_lyne_hollick.csv.gz")

# Calibration parameters
HB <- rechaRge::new_hydrobudget(
  T_m = 2.1, # melting temperature (°C)
  C_m = 6.2, # melting coefficient (mm/°C/d)
  TT_F = -17.6, # Threshold temperature for soil frost (°C)
  F_T = 16.4, # Freezing time (d)
  t_API = 3.9, # Antecedent precipitation index time (d)
  f_runoff = 0.63, # Runoff factor (-)
  sw_m = 431, # Maximum soil water content (mm)
  f_inf = 0.07 # infiltration factor (-)
)

# ... compute the water budget ...

result <- evaluate_simulation_quality(
  HB,
  water_budget = water_budget,
  rcn_gauging = input_rcn_gauging,
  observed_flow = input_observed_flow,
  alpha_lyne_hollick = input_alpha_lyne_hollick,
  period = simul_period
)
}
}
