% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constants.R, R/misc.R
\docType{data}
\name{WordBoundaries}
\alias{WordBoundaries}
\alias{BOUNDARY}
\alias{NOT_BOUNDARY}
\alias{whole_word}
\title{Word boundaries}
\format{An object of class \code{regex} (inherits from \code{character}) of length 1.}
\usage{
BOUNDARY

NOT_BOUNDARY

whole_word(x)
}
\arguments{
\item{x}{A character vector.}
}
\value{
A character vector representing part or all of a regular expression.
}
\description{
\code{BOUNDARY} matches a word boundary.
\code{whole_word} wraps a regex in word boundary tokens to match a whole
word.
}
\examples{
BOUNDARY
NOT_BOUNDARY

# Usage
x <- c("the catfish miaowed", "the tomcat miaowed", "the cat miaowed")
(rx_before <- BOUNDARY \%R\% "cat")
(rx_after <- "cat" \%R\% BOUNDARY)
(rx_whole_word <- whole_word("cat"))
stringi::stri_detect_regex(x, rx_before)
stringi::stri_detect_regex(x, rx_after)
stringi::stri_detect_regex(x, rx_whole_word)
}
\references{
\url{http://www.regular-expressions.info/wordboundaries.html} and
\url{http://www.rexegg.com/regex-boundaries.html}
}
\seealso{
\code{\link{ALPHA}}, \code{\link{BACKSLASH}}, \code{\link{START}}
}
\keyword{datasets}
