% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleaning_functions.R
\name{fuse_samples}
\alias{fuse_samples}
\title{Combine values for a composite parameter}
\usage{
fuse_samples(date_grp, qual, result, nd = c("<", "nd", "ND"))
}
\arguments{
\item{date_grp}{A date vector to group the dataset.}

\item{qual}{A character vector containing non-detect indicator strings, e.g., "<" or "ND". The strings used to indicate censored status can be edited in the "nd" argument.}

\item{result}{A numeric vector of concentration measurements.}

\item{nd}{A list indicating all the censoring flags included in the dataset. Defaults to "<", "nd", and "ND".}
}
\value{
A dataframe containing a column of sampling dates used to group data,
a qualifier column (character), and a MEC result column (numeric).
}
\description{
Calculate composite parameter concentrations using congener concentrations grouped by a sampling date vector. An example would application would be summing PCB congeners collected on a specific sampling date to produce a total PCBs concentration.
}
\examples{
df <- data.frame(dates = rep(seq.Date(from = as.Date("1982-03-10"),
                                      to = as.Date("1982-03-15"),
                                      by = 1), 5),
                 congeners = sort(rep(LETTERS[1:6], 5)),
                 qualifier = sample(c("<", ""), size = 30, 
                                    replace = TRUE, prob = c(0.8, 0.2)),
                 result = sample(seq(0.1, 0.5, 0.1), 30, replace = TRUE))

fuse_samples(df$dates, df$qualifier, df$result)


}
