% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm.empty.cols.R
\name{rm.empty.cols}
\alias{rm.empty.cols}
\title{Remove Empty Columns From an Imported Excel Sheet}
\usage{
rm.empty.cols(x, na.only = FALSE)
}
\arguments{
\item{x}{(\code{data.frame}). A data frame resulting from an imported Excel sheet by means of \command{read.xls}}

\item{na.only}{(\code{logical}). Should all 'NA' columns be removed and not only those with a column name starting
with X as generated by Excel (see details section)?}
}
\value{
A data frame.
}
\description{
\command{rm.empty.cols} removes columns that have only \code{NAs} \emph{AND} whose names
    start with a capital 'X' (unless \option{na.only} is \code{TRUE} in which case all \code{NA} columns
    will be removed).
}
\details{
Empty columns in Excel sheets are imported to \code{NA} columns in the resulting data frame.
    If using \code{gdata::read.xls} for reading Excel files, columns that did not have a column name in the
    spread sheet will result in data frame column names starting with 'X'. \command{rm.empty.cols} makes use
    of these two criteria to identify columns that can safely be removed from the data frame.
}
\keyword{utilities}
