% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save.R
\name{copy_rde_var}
\alias{copy_rde_var}
\title{Encode, compress and copy data into the clipboard}
\usage{
copy_rde_var(var, line.width = 80L, no.clipboard = FALSE)
}
\arguments{
\item{var}{the variable to copy}

\item{line.width}{the desired width of lines of text (-1 for no
line breaks)}

\item{no.clipboard}{the default is FALSE. Indicates that you want the
function to return the string that would have been copied to the clipboard
without actually copying to the clipboard. This option is mainly used
for testing purposes. Normal users will not use it.}
}
\value{
None (or string if no.clipboard=TRUE)
}
\description{
\code{copy_rde_var} is intended to work with \code{\link{load_rde_var}}.
The normal workflow would use \code{copy_rde_var} to copy a variable to
the clipboard and then paste it in to the third argument of
\code{load_rde_var}.
}
\details{
The variable in the argument \code{var} is first saved using
\code{\link{saveRDS}}. Then the saved variable is compressed using
bzip2 compression. Next, the compressed data is base 64 encoded into
a character string. Next, that string is prepended with a code that
indicates the version of this package. The prepended code (currently
`rde1` allows for future changes while providing backwards compatibility).
Finally, the string is optionally broken up into lines of width
\code{line.width}. Whitespace and line breaks are ignored by
\code{\link{load_rde_var}}.

On X11 systems (e.g. Linux), external software is required in order to
access the clipboard. Either `xsel` or `xclip` is required. Installation
of this software will depend on the installation that you use, but on
Ubuntu/Debian, `sudo apt-get install xsel` will probably work.

On Windows and OSX, no additional software is required.
}
\examples{
\dontrun{
copy_rde_var(iris)
}

}
