% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{ddi_useStmt}
\alias{ddi_useStmt}
\alias{ddi_citReq}
\alias{ddi_conditions}
\alias{ddi_confDec}
\alias{ddi_deposReq}
\alias{ddi_disclaimer}
\alias{ddi_restrctn}
\alias{ddi_specPerm}
\title{useStmt and its children}
\usage{
ddi_useStmt(...)

ddi_citReq(...)

ddi_conditions(...)

ddi_confDec(...)

ddi_deposReq(...)

ddi_disclaimer(...)

ddi_restrctn(...)

ddi_specPerm(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
Information on terms of use for the data collection. This element may be
repeated only to support multiple language expressions of the content.
More information on these elements, especially their allowed attributes, can
be found in the references.
}
\details{
\emph{Parent nodes}

\code{useStmt} is contained in the following elements: \code{dataAccs} and \code{sampleFrame}.

\emph{useStmt specific child nodes}
\itemize{
\item \code{ddi_citReq()} is the citation requirement. This is the text of requirement that
a data collection should be cited properly in articles or other publications
that are based on analysis of the data.
\item \code{ddi_conditions()} indicates any additional information that will assist the
user in understanding the access and use conditions of the data collection.
\item \code{ddi_confDec()} is the confidentiality declaration. This element is used to
determine if signing of a confidentiality declaration is needed to access a
resource.
\item \code{ddi_deposReq()} is the deposit requirement. This is information regarding
user responsibility for informing archives of their use of data through
providing citations to the published work or providing copies of the
manuscripts.
\item \code{ddi_disclaimer()} is information regarding responsibility for uses of the
data collection. This element may be repeated to support multiple language
expressions of the content.
\item \code{ddi_restrctn()} are any restrictions on access to or use of the collection
such as privacy certification or distribution restrictions should be
indicated here. These can be restrictions applied by the author, producer,
or disseminator of the data collection. If the data are restricted to only
a certain class of user, specify which type.
\item \code{ddi_specPerm()} is used to determine if any special permissions are required
to access a resource.
}
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_contact]{ddi_contact()}}
}
}

\examples{
ddi_useStmt()

# Functions that need to be wrapped in ddi_useStmt()

ddi_citReq(lang = "en",
           "Publications based on ICPSR data collections should acknowledge 
           those sources by means of bibliographic citations. To ensure that 
           such source attributions are captured for social science 
           bibliographic utilities, citations must appear in footnotes or in 
           the reference section of publications.")

ddi_conditions(lang = "en",
               "The data are available without restriction. Potential users 
               of these datasets are advised, however, to contact the original 
               principal investigator Dr. J. Smith (Institute for Social Research, 
               The University of Michigan, Box 1248, Ann Arbor, MI 48106), 
               about their intended uses of the data. Dr. Smith would also 
               appreciate receiving copies of reports based on the datasets.")

ddi_confDec(formNo = "1",
            "To download this dataset, the user must sign a declaration of confidentiality.")

ddi_deposReq("To provide funding agencies with essential information about 
             use of archival resources and to facilitate the exchange of 
             information about ICPSR participants' research activities, users 
             of ICPSR data are requested to send to ICPSR bibliographic 
             citations for, or copies of, each completed manuscript or thesis 
             abstract. Please indicate in a cover letter which data were used.")

ddi_disclaimer("The original collector of the data, ICPSR, and the relevant 
               funding agency bear no responsibility for uses of this collection 
               or for interpretations or inferences based upon such uses.")

ddi_restrctn("ICPSR obtained these data from the World Bank under the terms of 
             a contract which states that the data are for the sole use of 
             ICPSR and may not be sold or provided to third parties outside 
             of ICPSR membership. Individuals at institutions that are not 
             members of the ICPSR may obtain these data directly from the 
             World Bank.")

ddi_specPerm(formNo = "4",
             "The user must apply for special permission to use this dataset 
             locally and must complete a confidentiality form.")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/useStmt.html}{useStmt documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/citReq.html}{citReq documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/conditions.html}{conditions documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/confDec.html}{confDec documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/deposReq.html}{deposReq documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/disclaimer.html}{disclaimer documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/restrctn.html}{restrctn documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/specPerm.html}{specPerm documentation}
}
