% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stdyInfo.R
\name{ddi_standard}
\alias{ddi_standard}
\alias{ddi_standardName}
\title{standard and its child nodes}
\usage{
ddi_standard(...)

ddi_standardName(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
Standard describes a standard with which the study complies. More information
on these elements, especially their allowed attributes, can be found in the
references.
}
\details{
\emph{Parent nodes}

\code{standard} is contained in \code{standardsCompliance}.

\emph{standard specific child nodes}
\itemize{
\item \code{ddi_standardName()} contains the name of the standard with which the
study complies.
}
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_producer]{ddi_producer()}}
}
}

\examples{
ddi_standard()

# Functions that need to be wrapped in ddi_standard()

ddi_standardName(date = "2009-10-18",
                 version = "3.1",
                 URI = "http://www.ddialliance.org/Specification/DDI-Lifecycle/3.1/",
                 "Data Documentation Initiative")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/standard.html}{standard documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/standardName.html}{standardName documentation}
}
