% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{ddi_sampleFrame}
\alias{ddi_sampleFrame}
\alias{ddi_custodian}
\alias{ddi_referencePeriod}
\alias{ddi_sampleFrameName}
\alias{ddi_updateProcedure}
\alias{ddi_validPeriod}
\title{sampleFrame and its children}
\usage{
ddi_sampleFrame(...)

ddi_custodian(...)

ddi_referencePeriod(...)

ddi_sampleFrameName(...)

ddi_updateProcedure(...)

ddi_validPeriod(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
Sample frame describes the sampling frame used for identifying the population
from which the sample was taken. More information on these elements,
especially their allowed attributes, can be found in the references.
}
\details{
\emph{Parent nodes}

\code{sampleFrame} is contained in \code{dataColl}.

\emph{sampleFrame specific child nodes}
\itemize{
\item \code{ddi_custodian()} identifies the agency or individual who is responsible
for creating or maintaining the sample frame.
\item \code{ddi_referencePeriod()} indicates the period of time in which the sampling
frame was actually used for the study in question. Use ISO 8601 date/time
formats to enter the relevant date(s).
\item \code{ddi_sampleFrameName()} is the name of the sample frame.
\item \code{ddi_updateProcedure()} is the description of how and with what frequency
the sample frame is updated.
\item \code{ddi_validPeriod()} defines a time period for the validity of the sampling
frame. Enter dates in YYYY-MM-DD format.
}
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_frameUnit]{ddi_frameUnit()}}
\item \code{\link[=ddi_labl]{ddi_labl()}}
\item \code{\link[=ddi_txt]{ddi_txt()}}
\item \code{\link[=ddi_universe]{ddi_universe()}}
\item \code{\link[=ddi_useStmt]{ddi_useStmt()}}
}
}

\examples{
ddi_sampleFrame()

# Functions that need to be wrapped in ddi_sampleFrame()

ddi_custodian("DEX Publications")

ddi_referencePeriod(event = "single",
                    "2009-06-01")

ddi_sampleFrameName("City of St. Paul Directory")

ddi_updateProcedure("Changes are collected as they occur through registration 
                    and loss of phone number from the specified geographic 
                    area. Data are compiled for the date June 1st of odd 
                    numbered years, and published on July 1st for the following 
                    two-year period.")

ddi_validPeriod(event = "start", "2009-07-01")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/sampleFrame.html}{sampleFrame documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/custodian.html}{custodian documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/referencePeriod.html}{referencePeriod documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/sampleFrameName.html}{sampleFrameName documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/updateProcedure.html}{updateProcedure documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/validPeriod.html}{validPeriod documentation}
}
