% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{ddi_nCube}
\alias{ddi_nCube}
\alias{ddi_measure}
\alias{ddi_purpose}
\title{nCube and its child nodes}
\usage{
ddi_nCube(...)

ddi_measure(...)

ddi_purpose(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
Describes the logical structure of an n-dimensional array, in which each
coordinate intersects with every other dimension at a single point. The
nCube has been designed for use in the markup of aggregate data. Repetition
of the following elements is provided to support multi-language content:
anlysUnit, embargo, imputation, purpose, respUnit, and security. More
information on these elements, especially their allowed attributes, can be
found in the references.
}
\details{
\emph{Parent nodes}

\code{nCube} is contained in \code{dataDscr}.

\emph{nCube specific child nodes}
\itemize{
\item \code{ddi_measure()} indicates the measurement features of the cell content: type of
aggregation used, measurement unit, and measurement scale. An origin point
is recorded for anchored scales, to be used in determining relative movement
along the scale. Additivity indicates whether an aggregate is a stock
(like the population at a given point in time) or a flow (like the number of
births or deaths over a certain period of time). The non-additive flag is to
be used for measures that for logical reasons cannot be aggregated to a
higher level - for instance, data that only make sense at a certain level of
aggregation, like a classification. Two nCubes may be identical except for
their measure - for example, a count of persons by age and percent of
persons by age. Measure is an empty element.
\item \code{ddi_purpose()} explains the purpose for which a particular nCube was created.
}
}
\section{Shared and complex child nodes}{

\itemize{
\item \code{\link[=ddi_anlysUnit]{ddi_anlysUnit()}}
\item \code{\link[=ddi_embargo]{ddi_embargo()}}
\item \code{\link[=ddi_imputation]{ddi_imputation()}}
\item \code{\link[=ddi_labl]{ddi_labl()}}
\item \code{\link[=ddi_location]{ddi_location()}}
\item \code{\link[=ddi_notes]{ddi_notes()}}
\item \code{\link[=ddi_respUnit]{ddi_respUnit()}}
\item \code{\link[=ddi_security]{ddi_security()}}
\item \code{\link[=ddi_txt]{ddi_txt()}}
\item \code{\link[=ddi_universe]{ddi_universe()}}
\item \code{\link[=ddi_verStmt]{ddi_verStmt()}}
}
}

\examples{
ddi_nCube()

# Functions that need to be wrapped in ddi_nCube()

ddi_measure(aggrMeth = "sum", additivity = "stock")

ddi_purpose("Meets reporting requirements for the Federal Reserve Board")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/nCube.html}{nCube documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/measure.html}{measure documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/purpose.html}{purpose documentation}
}
