% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createCube.R
\name{createCube}
\alias{createCube}
\title{Creating cube size NxNxN}
\usage{
createCube(N = 3, mode = "normal", scheme = c("orange", "yellow",
  "blue", "white", "green", "red"))
}
\arguments{
\item{N}{integer - size of cube. Default value is 3, and minimum is 1.}

\item{mode}{string "normal" (default) or "octa" or "void". There are also are also available learning modes. Use keywords: "cross","first layer", "first two layers", "corners", "edges" to obtain your mode. For example "cross,centers", "corners" or "edges and centers". Default color scheme is the same as defined in parameter with added gray color.}

\item{scheme}{string vector - colour scheme for plotting cube. Name of colours should be given in specified order: front, top, right, bottom, left, back. In learning mode there is possibility to define 12 colors (standard 6 colors and 6 which are default gray).

Default value is c("orange","yellow","blue","white","green","red")}
}
\value{
Cube class object
}
\description{
Creates a cube object with empty moves and color scheme information
}
\examples{
# Create 3x3x3 cube with original color scheme:
cube <- createCube()
# Create 14x14x14 cube with original color scheme:
cube <- createCube(N = 14)
# Create 3x3x3 cube with "japanese" color scheme:
cube <- createCube(scheme = c("green","white","red","blue","orange","yellow"))
# Create 3x3x3 learning cubes:
c <- createCube(mode = "cross and centers")
c2 <- createCube(mode = "first layer and centers")
c3 <- createCube(mode = "first two layers")
# Create cube with coloured corners and edges:
c <- createCube(N = 4, mode = "corners and edges")
}
